package org.maachang.util;

import java.io.Serializable;

/**
 * ランダムインターフェイス.
 * 
 * @version 2008/12/12
 * @author masahito suzuki
 * @since MaachangBase 1.09
 */
public interface BaseRandom extends Serializable {
    /**
     * ランダム係数を設定.
     * @param seed ランダム係数を設定します.
     */
    public void setSeed(long seed) ;
    
    /**
     * 乱数バイナリを取得.
     * @param binary 格納先のバイナリを設定します.
     */
    public void nextBytes(byte[] binary) ;
    
    /**
     * 32ビット乱数を取得.
     * @return int 32ビット乱数が返されます.
     */
    public int nextInt() ;
    
    /**
     * 32ビット乱数を取得.
     * @param n 取得対象最大値を設定します.
     * @return int 32ビット乱数が返されます.
     */
    public int nextInt(int n) ;
    
    /**
     * 64ビット乱数を取得.
     * @return long 64Bit乱数が返されます.
     */
    public long nextLong() ;
    
    /**
     * Boolean乱数を取得.
     * @return boolean Boolean乱数が返されます.
     */
    public boolean nextBoolean() ;
    
    /**
     * Float乱数を取得.
     * @return float Float乱数が返されます.
     */
    public float nextFloat() ;
    
    /**
     * Double乱数を取得.
     * @return double Double乱数が返されます.
     */
    public double nextDouble() ;
}

