package org.maachang.util;

import org.maachang.util.atomic.AtomicLONG;

/**
 * drand48-ランダム処理.
 * 
 * @version 2008/12/11
 * @author masahito suzuki
 * @since MaachangBase 1.09
 */
public class Drand48Random extends AbstractBaseRandom implements BaseRandom {
	private static final long serialVersionUID = -4023698934857234442L;
	private static final long MASK = 0x0000ffffffffffffL ;
    private static final AtomicLONG seedUniquifier = new AtomicLONG( 8682522807148012L );
    private long s = 0x1234ABCD330EL ;
    
    /** nano時間セット. **/
    private long nano8bit() {
        return ( System.nanoTime() & 0x00000000000000ffL ) ;
    }
    
    /**
     * コンストラクタ.
     */
    public Drand48Random() {
        this( seedUniquifier.inc() ) ;
    }
    
    /**
     * コンストラクタ.
     * @param seed 乱数初期係数を設定します.
     */
    public Drand48Random( long seed ) {
        this.setSeed( seed ) ;
    }
    
    /**
     * ランダム係数を設定.
     * @param seed ランダム係数を設定します.
     */
    public final void setSeed(long seed) {
        seed = ( seed * nano8bit() ) & MASK ;
        s = ( (seed<<16L)+0x330EL ) & MASK ;
    }
    
    /**
     * 32ビット乱数を取得.
     * @return int 32ビット乱数が返されます.
     */
    public final int nextInt() {
        s = ((s*0x00000005DEECE66DL) + 0x000000000000000BL) & MASK;
        return (int)(s>>16L);
    }
}

