package org.maachang.util;

/**
 * 半角英数をカナ文字に変換.
 * 
 * @version 2008/07/03
 * @author masahito suzuki
 * @since MaachangBase 1.04
 */
public class EStoKana {
    
    private static final String[] DEST_HA = {
        "ｴｰ",
        "ﾋﾞｰ",
        "ｼｰ",
        "ﾃﾞｨｰ",
        "ｲｰ",
        "ｴﾌ",
        "ｼﾞｲｰ",
        "ｴｲﾁ",
        "ｱｲ",
        "ｼﾞｪｲ",
        "ｹｲ",
        "ｴﾙ",
        "ｴﾑ",
        "ｴﾇ",
        "ｵｰ",
        "ﾋﾟｰ",
        "ｷｭｳｰ",
        "ｱｰﾙ",
        "ｴｽ",
        "ﾃｨｰ",
        "ﾕｰ",
        "ﾌﾞｲ",
        "ﾀﾞﾌﾞﾙ",
        "ｴｯｸｽ",
        "ﾜｲ",
        "ｾﾞｯﾄ"
    } ;
    private static final String[] DEST_ZA = {
        "[ｴｰ]",
        "[ﾋﾞｰ]",
        "[ｼｰ]",
        "[ﾃﾞｨｰ]",
        "[ｲｰ]",
        "[ｴﾌ]",
        "[ｼﾞｲｰ]",
        "[ｴｲﾁ]",
        "[ｱｲ]",
        "[ｼﾞｪｲ]",
        "[ｹｲ]",
        "[ｴﾙ]",
        "[ｴﾑ]",
        "[ｴﾇ]",
        "[ｵｰ]",
        "[ﾋﾟｰ]",
        "[ｷｭｳｰ]",
        "[ｱｰﾙ]",
        "[ｴｽ]",
        "[ﾃｨｰ]",
        "[ﾕｰ]",
        "[ﾌﾞｲ]",
        "[ﾀﾞﾌﾞﾙ]",
        "[ｴｯｸｽ]",
        "[ﾜｲ]",
        "[ｾﾞｯﾄ]"
    } ;
    private static final String[] DEST_N = {
        "ｾﾞﾛ",
        "ｲﾁ",
        "ﾆ",
        "ｻﾝ",
        "ﾖﾝ",
        "ｺﾞ",
        "ﾛｸ",
        "ﾅﾅ",
        "ﾊﾁ",
        "ｷｭｳ"
    } ;
    
    private static final String NOT = "*" ;
    private static final String NEXT = "･" ;
    
    /**
     * 指定半角英数内容をカナ変換.
     * @param string 対象の文字列を設定します.
     * @return String 変換された内容が返されます.
     */
    public static final String convert( String string ) {
        if( string == null || ( string = string.trim() ).length() <= 0 ) {
            return "" ;
        }
        int len = string.length() ;
        StringBuilder buf = new StringBuilder() ;
        for( int i = 0 ; i < len ; i ++ ) {
            if( i != 0 ) {
                buf.append( NEXT ) ;
            }
            char c = string.charAt( i ) ;
            if( c >= 'a' && c <= 'z' ) {
                buf.append( DEST_HA[ ( int )( c - 'a' ) ] ) ;
            }
            else if( c >= 'A' && c <= 'Z' ) {
                buf.append( DEST_ZA[ ( int )( c - 'A' ) ] ) ;
            }
            else if( c >= '0' && c <= '9' ) {
                buf.append( DEST_N[ ( int )( c - '0' ) ] ) ;
            }
            else {
                buf.append( NOT ) ;
            }
        }
        return buf.toString() ;
    }
    
}
