package org.maachang.util;



/**
 * ランダムIDを生成.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaachangBase 1.00
 */
public class RandomId {
    private static final int ONE4BIT = 5 ;
    private int size = 0 ;
    
    /**
     * コンストラクタ.
     */
    private RandomId() {
        
    }
    
    /**
     * コンストラクタ.
     * 
     * @param size
     *            ランダムに設定する文字数を指定します.
     */
    public RandomId( int size ) {
        if (size <= 0) {
            throw new IllegalArgumentException("文字列長が不正です") ;
        }
        this.size = size ;
    }
    
    private static final byte[] ENC_CD = {
        (byte)'A', (byte)'B', (byte)'C', (byte)'D', (byte)'E', (byte)'F', (byte)'G', (byte)'H',
        (byte)'I', (byte)'J', (byte)'K', (byte)'L', (byte)'M', (byte)'N', (byte)'O', (byte)'P',
        (byte)'Q', (byte)'R', (byte)'S', (byte)'T', (byte)'U', (byte)'V', (byte)'W', (byte)'X',
        (byte)'Y', (byte)'Z', (byte)'a', (byte)'b', (byte)'c', (byte)'d', (byte)'e', (byte)'f',
        (byte)'g', (byte)'h', (byte)'i', (byte)'j', (byte)'k', (byte)'l', (byte)'m', (byte)'n',
        (byte)'o', (byte)'p', (byte)'q', (byte)'r', (byte)'s', (byte)'t', (byte)'u', (byte)'v',
        (byte)'w', (byte)'x', (byte)'y', (byte)'z', (byte)'0', (byte)'1', (byte)'2', (byte)'3',
        (byte)'4', (byte)'5', (byte)'6', (byte)'7', (byte)'8', (byte)'9', (byte)'+', (byte)'-'
    };
    
    /**
     * ランダムな文字列を取得.
     * @param rand ランダムオブジェクトを設定します.
     * @return String ランダムな文字列が返されます.
     * @exception Exception 例外.
     */
    public String get( BaseRandom rand ) throws Exception {
        int rnd ;
        int cnt = 0 ;
        int len = this.size ;
        byte[] buf = new byte[ len ] ;
        while( true ) {
            if( cnt + ONE4BIT > len ) {
                int last = len - cnt ;
                switch( last ) {
                    case 0 : break ;
                    case 1 :
                        rnd = rand.nextInt() ;
                        buf[cnt] = ENC_CD[ ( rnd & 0x0000003f ) ] ;
                        break ;
                    case 2 :
                        rnd = rand.nextInt() ;
                        buf[cnt] = ENC_CD[ ( rnd & 0x0000003f ) ] ;
                        cnt ++ ;
                        buf[cnt] = ENC_CD[ ( rnd & 0x00000fc0 ) >> 6 ] ;
                        break ;
                    case 3 :
                        rnd = rand.nextInt() ;
                        buf[cnt] = ENC_CD[ ( rnd & 0x0000003f ) ] ;
                        cnt ++ ;
                        buf[cnt] = ENC_CD[ ( rnd & 0x00000fc0 ) >> 6 ] ;
                        cnt ++ ;
                        buf[cnt] = ENC_CD[ ( rnd & 0x0003f000 ) >> 12 ] ;
                        break ;
                    case 4 :
                        rnd = rand.nextInt() ;
                        buf[cnt] = ENC_CD[ ( rnd & 0x0000003f ) ] ;
                        cnt ++ ;
                        buf[cnt] = ENC_CD[ ( rnd & 0x00000fc0 ) >> 6 ] ;
                        cnt ++ ;
                        buf[cnt] = ENC_CD[ ( rnd & 0x0003f000 ) >> 12 ] ;
                        cnt ++ ;
                        buf[cnt] = ENC_CD[ ( rnd & 0x00fc0000 ) >> 18 ] ;
                        break ;
                }
                break ;
            }
            else {
                rnd = rand.nextInt() ;
                buf[cnt] = ENC_CD[ ( rnd & 0x0000003f ) ] ;
                cnt ++ ;
                buf[cnt] = ENC_CD[ ( rnd & 0x00000fc0 ) >> 6 ] ;
                cnt ++ ;
                buf[cnt] = ENC_CD[ ( rnd & 0x0003f000 ) >> 12 ] ;
                cnt ++ ;
                buf[cnt] = ENC_CD[ ( rnd & 0x00fc0000 ) >> 18 ] ;
                cnt ++ ;
                buf[cnt] = ENC_CD[ ( rnd & 0x3f000000 ) >> 24 ] ;
                cnt ++ ;
            }
        }
        return new String( buf,"ISO8859_1" ) ;
    }
}
