package org.maachang.util;

import org.maachang.util.atomic.AtomicXor128Random;



/**
 * ランダム文字列を出力.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaachangBase 1.00
 */
public class RandomString {
    
    /** ランダム文字列出力用オブジェクト. **/
    protected static final RRV_RandTo prv_num = new RRV_RandNumber() ;
    protected static final RRV_RandTo prv_half = new RRV_RandHalf() ;
    protected static final RRV_RandTo prv_full = new RRV_RandFull() ;
    
    private RRV_RandTo[] randInfo = null ;
    private int randSize = 0 ;
    private int size = 0 ;
    
    /**
     * コンストラクタ.
     */
    private RandomString() {
        
    }
    
    /**
     * コンストラクタ.
     * 
     * @param size
     *            ランダムに設定する文字数を指定します.
     * @param number
     *            数字を許可するか指定します.
     * @param half
     *            半角文字を許可するか指定します.
     * @param full
     *            全角文字を許可するか指定します.
     */
    public RandomString( int size, boolean number,boolean half, boolean full ) {
        if (size <= 0 || (number == false && half == false && full == false)) {
            if (number == false && half == false && full == false) {
                number = true;
            } else {
                throw new IllegalArgumentException("文字列長が不正です") ;
            }
        }
        RRV_RandTo[] info = new RRV_RandTo[3];
        int randSize = 0;
        if (number == true) {
            info[randSize] = prv_num;
            randSize += 1;
        }
        if (half == true) {
            info[randSize] = prv_half;
            randSize += 1;
        }
        if (full == true) {
            info[randSize] = prv_full;
            randSize += 1;
        }
        this.randInfo = info ;
        this.randSize = randSize ;
        this.size = size ;
    }
    
    /**
     * ランダムな文字列を取得.
     * @param rand 対象のランダムオブジェクトを設定します.
     * @return String ランダムな文字列が返されます.
     */
    public String get( BaseRandom rand ) {
        RRV_RandTo[] info = this.randInfo ;
        int randSize = this.randSize ;
        int size = this.size ;
        StringBuilder buf = new StringBuilder(size);
        for (int i = 0; i < size; i++) {
            buf.append( info[rand.nextInt( randSize )].create( rand ) ) ;
        }
        return buf.toString() ;
    }
}

interface RRV_RandTo {
    public char create( BaseRandom rand ) ;
}
class RRV_RandNumber implements RRV_RandTo {
    private static final int RAND_STRING_TO_NUBER_BY_LENGTH = (int) ('9' - '0');
    private static final int ZERO = (int)'0' ;
    public char create( BaseRandom rand ) {
        return (char) (ZERO + (rand.nextInt(RAND_STRING_TO_NUBER_BY_LENGTH))) ;
    }
}
class RRV_RandHalf implements RRV_RandTo {
    private static final int RAND_STRING_TO_HALF_BY_LENGTH = (int) ('z' - 'a');
    private static final int ALS = (int)'a' ;
    public char create( BaseRandom rand ) {
        return (char) (ALS + (rand.nextInt(RAND_STRING_TO_HALF_BY_LENGTH))) ;
    }
}
class RRV_RandFull implements RRV_RandTo {
    private static final int RAND_STRING_TO_FULL_BY_LENGTH = (int) ('Z' - 'A');
    private static final int ALM = (int)'A' ;
    public char create( BaseRandom rand ) {
        return (char) (ALM + (rand.nextInt(RAND_STRING_TO_FULL_BY_LENGTH))) ;
    }
}

