package org.maachang.util;

import org.maachang.util.atomic.AtomicLONG;

/**
 * xor128-ランダム処理.
 * 
 * @version 2008/12/11
 * @author masahito suzuki
 * @since MaachangBase 1.09
 */
public class Xor128Random extends AbstractBaseRandom implements BaseRandom {
    private static final long serialVersionUID = 746227844186191007L;
    private static final AtomicLONG seedUniquifier = new AtomicLONG( 8682522807148012L );
    private int a = 123456789 ;
    private int b = 362436069 ;
    private int c = 521288629 ;
    private int d = 88675123 ;
    
    /** nano時間セット. **/
    private long nano8bit() {
        return ( System.nanoTime() & 0x00000000000000ffL ) ;
    }
    
    /**
     * コンストラクタ.
     */
    public Xor128Random() {
        this( seedUniquifier.inc() ) ;
    }
    
    /**
     * コンストラクタ.
     * @param seed 乱数初期係数を設定します.
     */
    public Xor128Random( long seed ) {
        this.setSeed( seed ) ;
    }
    
    /**
     * ランダム係数を設定.
     * @param seed ランダム係数を設定します.
     */
    public final void setSeed(long seed) {
        seed = ( seed * nano8bit() ) & 0x00ffffffffffffffL ;
        d = (int)( seed & 0x00000000ffffffffL ) ;
        nextInt() ;
        d = ( d ^ (int)( ( seed & 0xffffffff00000000L ) >> 32L ) ) ;
        nextInt() ;
    }
    
    /**
     * 32ビット乱数を取得.
     * @return int 32ビット乱数が返されます.
     */
    public final int nextInt() {
        int t,r ;
        t=a;r=t; t<<=11; t^=r;   r=t;  r>>=8;  t^=r;  r=b;a=r;
        r=c;b=r; r=d;c=r; t^=r;   r>>=19; r^=t; d=r;  return r;
    }
}

