package org.maachang.util.atomic ;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;

import org.maachang.util.SerializableUtil;

/**
 * AtomicBeans.
 * 
 * @version 2008/12/01
 * @author masahito suzuki
 * @since MaachangBase 1.09
 */
public class AtomicBEANS implements Serializable {
    private static final long serialVersionUID = 8257074739650323863L;
    private final AtomicReference<Serializable> ato = new AtomicReference<Serializable>() ;
    
    /**
     * コンストラクタ.
     */
    public AtomicBEANS() {
        
    }
    
    /**
     * コンストラクタ.
     * @param b 初期値を設定します.
     */
    public AtomicBEANS( Serializable b ) {
        setting( b ) ;
    }
    
    /**
     * オブジェクトを取得.
     * @return Serializable オブジェクトが返されます.
     * @exception Exception 例外.
     */
    public Serializable get() {
        try {
            return cloneObject( ato.get() ) ;
        } catch( Exception e ) {
            throw new RuntimeException( e ) ;
        }
    }
    
    /**
     * オブジェクトを更新.
     * @param b 対象オブジェクトを設定します.
     */
    public void update( Serializable b ) {
        setting( b ) ;
    }
    
    /**
     * オブジェクトを設定.
     * @param b 対象オブジェクトを設定します.
     */
    public void set( Serializable b ) {
        setting( b ) ;
    }
    
    private void setting( Serializable b ) {
        while( !ato.compareAndSet( ato.get(),b ) ) {}
    }
    
    private Serializable cloneObject( Serializable b ) throws Exception {
        if( b == null ) {
            return null ;
        }
        return cloneBySerializable( b ) ;
    }
    
    /** シリアライズでオブジェクト複製 **/
    protected Serializable cloneBySerializable( Serializable b ) throws Exception {
        return SerializableUtil.toObject( SerializableUtil.toBinary( b ) ) ;
    }
    
    /** リフレクションでオブジェクト複製 **/
    /*protected Serializable cloneByReflect( Serializable b ) throws Exception {
        Class c = b.getClass() ;
        Method[] ms = c.getMethods() ;
        int len ;
        if( ms != null && ( len = ms.length ) > 0 ) {
            Serializable n = ( Serializable )Class.forName( c.getName() ).newInstance() ;
            boolean getFlg ;
            String name ;
            Method md ;
            String setMethodName ;
            for( int i = 0 ; i < len ; i ++ ) {
                md = ms[ i ] ;
                name = md.getName() ;
                if( ( md.getParameterTypes() == null || md.getParameterTypes().length <= 0 ) &&
                    ( ( getFlg = name.startsWith( "get" ) ) || name.startsWith( "is" ) ) ) {
                    if( getFlg ) {
                        setMethodName = new StringBuilder().append( "set" ).append( name.substring( 3 ) ).toString() ;
                    }
                    else {
                        setMethodName = new StringBuilder().append( "set" ).append( name.substring( 2 ) ).toString() ;
                    }
                    try {
                        Method sm = c.getMethod( setMethodName,md.getReturnType() ) ;
                        sm.invoke( n,md.invoke( b ) ) ;
                    } catch( Exception e ) {
                    }
                }
            }
            return n ;
        }
        return null ;
    }*/
}
