package org.maachang.util.atomic ;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * AtomicFLOAT.
 * 
 * @version 2008/12/02
 * @author masahito suzuki
 * @since MaachangBase 1.09
 */
public class AtomicFLOAT implements Serializable,AtomicPrimitive {
    private static final long serialVersionUID = -5471996857123960748L;
    private final AtomicInteger ato = new AtomicInteger( 0 ) ;
    
    /**
     * コンストラクタ.
     */
    public AtomicFLOAT() {
        
    }
    
    /**
     * コンストラクタ.
     * @param n 初期値を設定します.
     */
    public AtomicFLOAT( float n ) {
        setting( Float.floatToIntBits( n ) ) ;
    }
    
    /**
     * コンストラクタ.
     * @param n 初期値を設定します.
     */
    public AtomicFLOAT( Float n ) {
        if( n != null ) {
            setting( Float.floatToIntBits( n.floatValue() ) ) ;
        }
    }
    
    /**
     * float値を取得.
     * @return float float値が返されます.
     */
    public float get() {
        return Float.intBitsToFloat( ato.get() ) ;
    }
    
    /**
     * Float値を取得.
     * @return Float Float値が返されます.
     */
    public Float getObject() {
        return new Float( get() ) ;
    }
    
    /**
     * float値を設定.
     * @param n float値を設定します.
     */
    public void set( float n ) {
        setting( Float.floatToIntBits( n ) ) ;
    }
    
    /**
     * Float値を設定.
     * @param n Float値を設定します.
     */
    public void set( Float n ) {
        if( n != null ) {
            setting( Float.floatToIntBits( n.floatValue() ) ) ;
        }
    }
    
    /**
     * 指定数の足し算.
     * @param no 対象の数値を設定します.
     * @return float 結果内容が返されます.
     */
    public float add( float no ) {
        int n ;
        int r ;
        while( true ) {
            n = ato.get() ;
            r = Float.floatToIntBits( Float.intBitsToFloat( n ) + no ) ;
            if( ato.compareAndSet( n,r ) ) {
                return Float.intBitsToFloat( r ) ;
            }
        }
    }
    
    /**
     * 指定数の足し算.
     * @param no 対象の数値を設定します.
     * @return float 結果内容が返されます.
     */
    public float add( Float no ) {
        if( no == null ) {
            return -1f ;
        }
        int n ;
        int r ;
        float x = no.floatValue() ;
        while( true ) {
            n = ato.get() ;
            r = Float.floatToIntBits( Float.intBitsToFloat( n ) + x ) ;
            if( ato.compareAndSet( n,r ) ) {
                return Float.intBitsToFloat( r ) ;
            }
        }
    }
    
    /**
     * 指定数の引き算.
     * @param no 対象の数値を設定します.
     * @return float 結果内容が返されます.
     */
    public float remove( float no ) {
        int n ;
        int r ;
        while( true ) {
            n = ato.get() ;
            r = Float.floatToIntBits( Float.intBitsToFloat( n ) - no ) ;
            if( ato.compareAndSet( n,r ) ) {
                return Float.intBitsToFloat( r ) ;
            }
        }
    }
    
    /**
     * 指定数の引き算.
     * @param no 対象の数値を設定します.
     * @return float 結果内容が返されます.
     */
    public float remove( Float no ) {
        if( no == null ) {
            return -1f ;
        }
        int n ;
        int r ;
        float x = no.floatValue() ;
        while( true ) {
            n = ato.get() ;
            r = Float.floatToIntBits( Float.intBitsToFloat( n ) - x ) ;
            if( ato.compareAndSet( n,r ) ) {
                return Float.intBitsToFloat( r ) ;
            }
        }
    }
    
    /**
     * 1インクリメント.
     * @return float 結果内容が返されます.
     */
    public float inc() {
        int n ;
        int r ;
        while( true ) {
            n = ato.get() ;
            r = Float.floatToIntBits( Float.intBitsToFloat( n ) + 1.0f ) ;
            if( ato.compareAndSet( n,r ) ) {
                return Float.intBitsToFloat( r ) ;
            }
        }
    }
    
    /**
     * 1デクリメント.
     * @return float 結果内容が返されます.
     */
    public float dec() {
        int n ;
        int r ;
        while( true ) {
            n = ato.get() ;
            r = Float.floatToIntBits( Float.intBitsToFloat( n ) - 1.0f ) ;
            if( ato.compareAndSet( n,r ) ) {
                return Float.intBitsToFloat( r ) ;
            }
        }
    }
    
    /**
     * 文字列変換.
     * @return String 文字列が返されます.
     */
    public String toString() {
        return String.valueOf( get() ) ;
    }
    
    /**
     * オブジェクトを取得.
     * @return Object オブジェクトが返されます.
     */
    public Object base() {
        return ato ;
    }
    
    /**
     * オブジェクトタイプを取得.
     * @return int java.sql.Typesの各条件が返されます.
     */
    public int getType() {
        return java.sql.Types.FLOAT ;
    }
    
    private void setting( int no ) {
        while( true ) {
            if( ato.compareAndSet( ato.get(),no ) ) {
                break ;
            }
        }
    }
}
