package org.maachang.util.atomic ;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;

/**
 * AtomicLONG.
 * 
 * @version 2008/12/01
 * @author masahito suzuki
 * @since MaachangBase 1.09
 */
public class AtomicLONG implements Serializable,AtomicPrimitive {
    private static final long serialVersionUID = 9075166340272133267L;
    private final AtomicLong ato = new AtomicLong( 0L ) ;
    
    /**
     * コンストラクタ.
     */
    public AtomicLONG() {
        
    }
    
    /**
     * コンストラクタ.
     * @param n 初期値を設定します.
     */
    public AtomicLONG( long n ) {
        setting( n ) ;
    }
    
    /**
     * コンストラクタ.
     * @param n 初期値を設定します.
     */
    public AtomicLONG( Long n ) {
        if( n != null ) {
            setting( n.longValue() ) ;
        }
    }
    
    /**
     * long値を取得.
     * @return long long値が返されます.
     */
    public long get() {
        return ato.get() ;
    }
    
    /**
     * Long値を取得.
     * @return Long Long値が返されます.
     */
    public Long getObject() {
        return new Long( ato.get() ) ;
    }
    
    /**
     * long値を設定.
     * @param n long値を設定します.
     */
    public void set( long n ) {
        setting( n ) ;
    }
    
    /**
     * Long値を設定.
     * @param n Long値を設定します.
     */
    public void set( Long n ) {
        if( n != null ) {
            setting( n.longValue() ) ;
        }
    }
    
    /**
     * 指定数の足し算.
     * @param no 対象の数値を設定します.
     * @return long 結果内容が返されます.
     */
    public long add( long no ) {
        long n ;
        long r ;
        while( true ) {
            n = ato.get() ;
            r = n + no ;
            if( ato.compareAndSet( n,r ) ) {
                return r ;
            }
        }
    }
    
    /**
     * 指定数の足し算.
     * @param no 対象の数値を設定します.
     * @return long 結果内容が返されます.
     */
    public long add( Long no ) {
        if( no == null ) {
            return -1L ;
        }
        long n ;
        long r ;
        long x = no.longValue() ;
        while( true ) {
            n = ato.get() ;
            r = n + x ;
            if( ato.compareAndSet( n,r ) ) {
                return r ;
            }
        }
    }
    
    /**
     * 指定数の引き算.
     * @param no 対象の数値を設定します.
     * @return long 結果内容が返されます.
     */
    public long remove( long no ) {
        long n ;
        long r ;
        while( true ) {
            n = ato.get() ;
            r = n - no ;
            if( ato.compareAndSet( n,r ) ) {
                return r ;
            }
        }
    }
    
    /**
     * 指定数の引き算.
     * @param no 対象の数値を設定します.
     * @return long 結果内容が返されます.
     */
    public long remove( Long no ) {
        if( no == null ) {
            return -1L ;
        }
        long n ;
        long r ;
        long x = no.intValue() ;
        while( true ) {
            n = ato.get() ;
            r = n - x ;
            if( ato.compareAndSet( n,r ) ) {
                return r ;
            }
        }
    }
    
    /**
     * 1インクリメント.
     * @return long 結果内容が返されます.
     */
    public long inc() {
        long n ;
        long r ;
        while( true ) {
            n = ato.get() ;
            r = n + 1L ;
            if( ato.compareAndSet( n,r ) ) {
                return r ;
            }
        }
    }
    
    /**
     * 1デクリメント.
     * @return long 結果内容が返されます.
     */
    public long dec() {
        long n ;
        long r ;
        while( true ) {
            n = ato.get() ;
            r = n - 1L ;
            if( ato.compareAndSet( n,r ) ) {
                return r ;
            }
        }
    }
    
    /**
     * 文字列変換.
     * @return String 文字列が返されます.
     */
    public String toString() {
        return String.valueOf( get() ) ;
    }
    
    /**
     * オブジェクトを取得.
     * @return Object オブジェクトが返されます.
     */
    public Object base() {
        return ato ;
    }
    
    /**
     * オブジェクトタイプを取得.
     * @return int java.sql.Typesの各条件が返されます.
     */
    public int getType() {
        return java.sql.Types.BIGINT ;
    }
    
    private void setting( long no ) {
        while( true ) {
            if( ato.compareAndSet( ato.get(),no ) ) {
                break ;
            }
        }
    }
}
