package org.maachang.util.atomic ;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;


/**
 * AtomicLock.
 * 
 * @version 2008/12/11
 * @author masahito suzuki
 * @since MaachangBase 1.09
 */
public class AtomicLock {
    
    private final AtomicInteger lock = new AtomicInteger( 0 ) ;
    private final TimeUnit unit = TimeUnit.MICROSECONDS ;
    
    /**
     * コンストラクタ.
     */
    public AtomicLock() {
        
    }
    
    /**
     * ロック処理.
     */
    public final void lock() {
        if( !lock.compareAndSet( 0,1 ) ) {
            try {
                while( !lock.compareAndSet( 0,1 ) ) {
                    unit.sleep(1) ;
                }
            } catch( Exception e ) {
                throw new IllegalMonitorStateException( e.getMessage() ) ;
            }
        }
    }
    
    /**
     * アンロック処理.
     */
    public final void unlock() {
        if( !lock.compareAndSet( lock.get(),0 ) ) {
            try {
                while( !lock.compareAndSet( lock.get(),0 ) ) {
                    unit.sleep(1) ;
                }
            } catch( Exception e ) {
                throw new IllegalMonitorStateException( e.getMessage() ) ;
            }
        }
    }
}
