package org.maachang.util.atomic ;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;

/**
 * AtomicOBJECT.
 * 
 * @version 2008/12/01
 * @author masahito suzuki
 * @since MaachangBase 1.09
 */
public class AtomicOBJECT<T> implements Serializable {
    private static final long serialVersionUID = -89137212990217594L;
    private final AtomicReference<T> ato = new AtomicReference<T>() ;
    
    /**
     * コンストラクタ.
     */
    public AtomicOBJECT() {
        
    }
    
    /**
     * コンストラクタ.
     * @param f 初期値を設定します.
     */
    public AtomicOBJECT( T t ) {
        setting( t ) ;
    }
    
    /**
     * Object値を取得.
     * @return T Object値が返されます.
     */
    public T get() {
        return ato.get() ;
    }
    
    /**
     * Objectを設定.
     * @param t 対象オブジェクトを設定します.
     */
    public void set( T t ) {
        setting( t ) ;
    }
    
    /**
     * 文字列変換.
     * @return String 文字列が返されます.
     */
    public String toString() {
        return String.valueOf( get() ) ;
    }
    
    private void setting( T t ) {
        while( true ) {
            if( ato.compareAndSet( ato.get(),t ) ) {
                break ;
            }
        }
    }
}
