package org.maachang.util.nativeio;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * NativeI/O生成用.
 * 
 * @version 2008/11/29
 * @author  masahito suzuki
 * @since   MaachangBase-1.09
 */
public abstract class NativeIOInstance {
    private NativeIOInstance() {}
    
    /**
     * ランダムアクセス用オブジェクトを生成.
     * @param name 対象のファイル名を設定します.
     * @return RandomIO ランダムアクセス用オブジェクトが返されます.
     * @exception Exception 例外.
     */
    public static final RandomIO randomIO( String name ) throws Exception {
        if( NativeIO.useInit() ) {
            return new NativeRandomIO( name ) ;
        }
        else {
            return new JavaRandomIO( name ) ;
        }
    }
    
    /**
     * InputStreamを生成.
     * @param name 対象のファイル名を設定します.
     * @return InputStream BufferedInputStream相当のオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public static final InputStream inputStream( String name ) throws Exception {
        if( NativeIO.useInit() ) {
            return new NativeInputStream( name ) ;
        }
        else {
            return new BufferedInputStream( new FileInputStream( name ) ) ;
        }
    }
    
    /**
     * OutputStreamを生成.
     * @param name 対象のファイル名を設定します.
     * @return OutputStream BufferedOutputStream相当のオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public static final OutputStream outputStream( String name ) throws Exception {
        return outputStream( true,name ) ;
    }
    
    /**
     * OutputStreamを生成.
     * @param mode [true]の場合、既にファイルが存在しても0バイト目から書き込み処理を行います.
     * @param name 対象のファイル名を設定します.
     * @return OutputStream BufferedOutputStream相当のオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public static final OutputStream outputStream( boolean mode,String name ) throws Exception {
        if( NativeIO.useInit() ) {
            return new NativeOutputStream( mode,name ) ;
        }
        else {
            if( mode == false ) {
                return new BufferedOutputStream( new FileOutputStream( name,true ) ) ;
            }
            else {
                return new BufferedOutputStream( new FileOutputStream( name ) ) ;
            }
        }
    }
    
}
