package org.maachang.util.nativeio;

import java.io.IOException;
import java.io.InputStream;

/**
 * NativeInputStream.
 * 
 * @version 2008/11/29
 * @author  masahito suzuki
 * @since   MaachangBase-1.09
 */
class NativeInputStream extends InputStream {
    private static final int TEMP_LEN = 4096 ;
    private final byte[] temp = new byte[ TEMP_LEN ] ;
    private int position = 0 ;
    private int length = 0 ;
    private long handle = -1L ;
    private long fileSize = 0L ;
    private long allPos = 0L ;
    
    private NativeInputStream() {
        
    }
    
    public NativeInputStream( String name ) throws Exception {
        if( name == null || ( name = name.trim() ).length() <= 0 ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        if( NativeIODefine.useFile( name ) == false ) {
            throw new IllegalArgumentException( "指定ファイル[" + name + "]は存在しません" ) ;
        }
        name = NativeIODefine.fullPath( name ) ;
        this.handle = NativeIO.open( 1,0,NativeIODefine.nativeString( name ) ) ;
        if( this.handle == -1L ) {
            throw new IOException( "指定ファイル[" + name + "]のオープンに失敗しました" ) ;
        }
        this.fileSize = NativeIO.getLength( this.handle ) ;
    }
    
    protected void finalize() throws Exception {
        try {
            close() ;
        } catch( Exception e ) {
        }
    }
    
    public void close() {
        if( this.handle > -1L ) {
            NativeIO.close( this.handle ) ;
            this.handle = -1L ;
            this.position = 0 ;
            this.length = -1 ;
            this.fileSize = -1L ;
            this.allPos = -1L ;
        }
    }
    
    public int available() throws IOException {
        if( handle <= -1L ) {
            throw new IOException( "ファイルは既にクローズしています" ) ;
        }
        return ( int )( ( fileSize - allPos ) & 0x000000007fffffffL ) ;
    }
    
    public int read() throws IOException {
        if( handle <= -1L ) {
            throw new IOException( "ファイルは既にクローズしています" ) ;
        }
        if( length <= -1 ) {
            return -1 ;
        }
        if( position >= length ) {
            length = NativeIO.read( handle,-1L,temp,0,TEMP_LEN ) ;
            position = 0 ;
            if( length <= 0 ) {
                length = -1 ;
                return -1 ;
            }
        }
        int ret = ( int )( temp[ position ] & 0x000000ff ) ;
        position ++ ;
        allPos ++ ;
        return ret ;
    }
    
    public boolean markSupported() {
        return false ;
    }
}
