package org.maachang.util.nativeio;

import java.io.IOException;
import java.io.OutputStream;

/**
 * NativeOutputStream.
 * 
 * @version 2008/11/29
 * @author  masahito suzuki
 * @since   MaachangBase-1.09
 */
class NativeOutputStream extends OutputStream {
    private static final int TEMP_LEN = 4096 ;
    private final byte[] temp = new byte[ TEMP_LEN ] ;
    private int position = 0 ;
    private long handle = -1L ;
    
    private NativeOutputStream() {
        
    }
    
    public NativeOutputStream( boolean mode,String name ) throws Exception {
        if( name == null || ( name = name.trim() ).length() <= 0 ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        name = NativeIODefine.fullPath( name ) ;
        boolean useFileFlag = NativeIODefine.useFile( name ) ;
        this.handle = NativeIO.open( 1,1,NativeIODefine.nativeString( name ) ) ;
        if( this.handle == -1L ) {
            throw new IOException( "指定ファイル[" + name + "]のオープンに失敗しました" ) ;
        }
        if( useFileFlag && mode ) {
            NativeIO.setLength( this.handle,0L ) ;
        }
    }
    
    protected void finalize() throws Exception {
        close() ;
    }
    
    public void close() throws IOException {
        if( this.handle > -1L ) {
            flush() ;
            NativeIO.close( this.handle ) ;
            this.handle = -1L ;
            this.position = 0 ;
        }
    }
    
    public void flush() throws IOException {
        if( handle <= -1L ) {
            throw new IOException( "ファイルは既にクローズしています" ) ;
        }
        if( position > 0 ) {
            NativeIO.write( handle,-1L,temp,0,position ) ;
            position = 0 ;
        }
    }
    
    public void write(int b) throws IOException {
        if( position >= TEMP_LEN ) {
            flush() ;
        }
        temp[ position ] = ( byte )b ;
        position ++ ;
    }
}
