package org.maachang.util.nativeio;

/**
 * ランダムI/Oインターフェイス.
 * 
 * @version 2008/11/29
 * @author  masahito suzuki
 * @since   MaachangBase-1.09
 */
public interface RandomIO {
    
    /**
     * オブジェクトタイプ : ネイティブ.
     */
    public static final int TYPE_NATIVE = 0 ;
    
    /**
     * オブジェクトタイプ : Javaオブジェクト.
     */
    public static final int TYPE_JAVA = 1 ;
    
    /**
     * クローズ処理.
     */
    public void close() ;
    
    /**
     * 読み込み処理.
     * @param binary 読み込み先バイナリを設定します.
     * @param seek シーク位置を設定します.
     * @param offset 読み込みオフセット値を設定します.
     * @param length 読み込みデータ長を設定します.
     * @return int 読み込みデータ長が返されます.
     * @exception Exception 例外.
     */
    public int read( byte[] binary,long seek,int offset,int length )
        throws Exception ;
    
    /**
     * 書込み処理.
     * @param binary 書込み先バイナリを設定します.
     * @param seek シーク位置を設定します.
     * @param offset 書込みオフセット値を設定します.
     * @param length 書込みデータ長を設定します.
     * @exception Exception 例外.
     */
    public void write( byte[] binary,long seek,int offset,int length )
        throws Exception ;
    
    /**
     * 現在のファイルサイズを取得.
     * @return long ファイルサイズが返されます.
     * @exception Exception 例外.
     */
    public long length() throws Exception ;
    
    /**
     * ファイルサイズを設定.
     * @param length ファイルサイズを設定します.
     * @exception Exception 例外.
     */
    public void length( long length ) throws Exception ;
    
    /**
     * オープンファイル名を取得.
     * @return String オープンファイル名が返されます.
     */
    public String getName() ;
    
    /**
     * オブジェクトタイプを取得.
     * @return int オブジェクトタイプが返されます.
     */
    public int getType() ;
    
    /**
     * ファイルがオープン中かチェック.
     * @return boolean [true]の場合、オープンしています.
     */
    public boolean isOpen() ;
}
