package org.maachang.util.net;

import java.io.IOException;
import java.util.Locale;

import org.maachang.util.Os;

/**
 * ネットワークアダプタFactory.
 * 
 * @version 2008/10/29
 * @author masahito suzuki
 * @since MaachangBase 1.08
 */
public abstract class NetAdapterFactory {
    /**
     * NetAdapterを取得.
     * @return NetAdapter NetAdapterが返されます.
     * @exception Exception 例外.
     */
    public static final NetAdapter get() throws Exception {
        String osName = System.getProperty( "os.name" ).toLowerCase( Locale.US ) ;
        switch (Os.getInstance().getOS()) {
        case Os.OS_WINNT:
            return new NetAdapterByWinNT() ;
        case Os.OS_UNIX:
            if( osName.indexOf( "linux" ) != -1 ) {
                return new NetAdapterByLinux() ;
            }
            else {
                return new NetAdapterByBsd() ;
            }
            
        case Os.OS_MAC_OS_X:
            return new NetAdapterByBsd() ;
        default:
            throw new IOException("実行中のOSでは利用できません");
        }
    }
    
    /** test. **/
    public static final void main( String[] args ) throws Exception {
        NetAdapter ad = get() ;
        ad.load() ;
        System.out.println( ad ) ;
    }
}
