package org.maachang.comet.conf ;

import org.maachang.comet.MaachangDef;
import org.maachang.comet.ServiceDef;
import org.maachang.comet.httpd.engine.script.cache.CacheScriptManager;
import org.maachang.dao.dbms.RecordFactory;
import org.maachang.manager.GlobalManager;
import org.maachang.util.FileUtil;

/**
 * 最小コンフィグファイル読み込み.
 * 
 * @version 2007/09/30
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public class MinStartupConfig {
    
    /**
     * コンフィグ情報を初期化.
     * <BR><BR>
     * コンフィグ情報を初期化します.
     * <BR>
     * @param path 対象のパスを設定します.
     * @exception Exception 例外.
     */
    public static final void init( String path )
        throws Exception {
        path = StartupConfig.getPath( path ) ;
        String confPath = path+MaachangDef.DIRECTORY_CONFIG ;
        confPath = FileUtil.getFullPath( confPath )+FileUtil.FILE_SPACE ;
        BaseConfig baseConfig = getBaseConfig( confPath ) ;
        readMinConfig( baseConfig ) ;
        setConfig( confPath,baseConfig ) ;
        RecordFactory factory = getRecordFactory() ;
        if( factory != null && factory.getSupportKind() == null ) {
            throw new IllegalArgumentException( "アダプタ名が非サポートデータベースです" ) ;
        }
        PackagesConfig pconf = getPackagesConfig( confPath,baseConfig ) ;
        if( pconf == null ) {
            throw new IllegalArgumentException( "パッケージコンフィグの読み込みに失敗しました" ) ;
        }
        if( factory != null ) {
            GlobalManager.getInstance().put( ServiceDef.MANAGER_BY_DBMS_POOL,factory ) ;
        }
        createCacheScriptManager() ;
        GlobalManager.getInstance().put( ServiceDef.MANAGER_BY_PACKAGES,pconf ) ;
    }
    
    /**
     * コンフィグ情報を設定.
     */
    private static void setConfig( String path,BaseConfig bconf )
        throws Exception {
        int len = bconf.size() ;
        IniFile config = new IniFile() ;
        for( int i = 0 ; i < len ; i ++ ) {
            String name = bconf.getConfig( i ) ;
            if( name == null || ( name = name.trim() ).length() <= 0 ) {
                continue ;
            }
            StartupConfig.readConfig( config,path,name ) ;
        }
        GlobalManager nm = GlobalManager.getInstance() ;
        nm.put( ServiceDef.MANAGER_BY_CONFIG,config ) ;
    }
    
    /**
     * レコードFactoryを取得.
     */
    private static RecordFactory getRecordFactory()
        throws Exception {
        GlobalManager nm = GlobalManager.getInstance() ;
        IniFile config = ( IniFile )nm.get( ServiceDef.MANAGER_BY_CONFIG ) ;
        return StartupConfig.getRecordFactory( false,config ) ;
    }
    
    /**
     * キャッシュスクリプトマネージャを取得.
     */
    private static void createCacheScriptManager()
        throws Exception {
        CacheScriptManager.init() ;
    }
    
    /**
     * packages情報を取得.
     */
    private static final PackagesConfig getPackagesConfig( String path,BaseConfig bconf )
        throws Exception {
        String packages = path+bconf.getPackages() ;
        if( packages.endsWith( ".conf" ) == false ) {
            packages += ".conf" ;
        }
        PackagesConfig packagesConf = new PackagesConfig() ;
        packagesConf.open( packages ) ;
        return packagesConf ;
    }
    
    /**
     * BaseConfigを取得.
     */
    private static final BaseConfig getBaseConfig( String path )
        throws Exception {
        return StartupConfig.getBaseConfig( path ) ;
    }
    
    /**
     * コンフィグファイル拡張子.
     */
    private static final String CONF = ".conf" ;
    
    /**
     * 最低限の条件を読み込む.
     */
    private static final void readMinConfig( BaseConfig conf )
        throws Exception {
        String path = "./"+MaachangDef.DIRECTORY_CONFIG ;
        path = FileUtil.getFullPath( path )+FileUtil.FILE_SPACE ;
        GlobalManager nm = GlobalManager.getInstance() ;
        String mime = path+conf.getMimes() ;
        if( mime.endsWith( CONF ) == false ) {
            mime += CONF ;
        }
        // Mimeを登録.
        MimeConfig mimeType = new MimeConfig() ;
        mimeType.open( mime ) ;
        nm.put( ServiceDef.MANAGER_BY_MIME_TYPE,mimeType ) ;// Mime.
        
        // Mailを取得.
        String mail = path+conf.getMail() ;
        if( mail.endsWith( CONF ) == false ) {
            mail += CONF ;
        }
        // Mailを登録.
        MailConfig mailConfig = new MailConfig() ;
        mailConfig.open( mail ) ;
        nm.put( ServiceDef.MANAGER_BY_MAIL_CONFIG,mailConfig ) ;// Mail.
    }
}
