package org.maachang.comet.httpd ;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.maachang.comet.httpd.engine.HttpdDef;
import org.maachang.conf.ConvIniParam;

/**
 * HTTPD-ヘッダ群.
 *
 * @version 2007/08/20
 * @author  masahito suzuki
 * @since   MaachangComet 1.00
 */
public interface HttpdHeaders {
    
    /**
     * ヘッダオブジェクトをマージ.
     * <BR><BR>
     * 指定オブジェクトをマージします.
     * <BR>
     * @param header 対象のヘッダオブジェクトを設定します.
     */
    public void add( HttpdHeaders header ) ;
    
    /**
     * パラメータ追加.
     * <BR><BR>
     * パラメータを追加します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @param value 対象の要素を設定します.
     */
    public void addHeader( String key,String value ) ;
    
    /**
     * パラメータ設定.
     * <BR><BR>
     * パラメータを設定します.<BR>
     * この条件で設定した場合、以前に登録したkeyに
     * 対する内容はクリアされます.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @param value 対象の要素を設定します.
     */
    public void setHeader( String key,String value ) ;
    
    /**
     * パラメータを削除.
     * <BR><BR>
     * 対象のパラメータを削除します.
     * <BR>
     * @param key 対象のキー名を設定します.
     */
    public void removeHeader( String key ) ;
    
    /**
     * パラメータを削除.
     * <BR><BR>
     * 対象のパラメータを削除します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @param no 対象の項番を設定します.
     */
    public void removeHeader( String key,int no ) ;
    
    /**
     * パラメータを取得.
     * <BR><BR>
     * 対象のパラメータを取得します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @return String 対象の要素情報が返されます.
     */
    public String getHeader( String key ) ;
    
    /**
     * パラメータを取得.
     * <BR><BR>
     * 対象のパラメータを取得します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @param no 対象の項番を設定します.
     * @return String 対象の要素情報が返されます.
     */
    public String getHeader( String key,int no ) ;
    
    /**
     * ヘッダ群を取得.
     * <BR><BR>
     * 対象のヘッダ群を取得します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @return HashMap<String,String> パースされたヘッダ情報が返されます.
     */
    public HashMap<String,String> getHeaders( String key ) ;
    
    /**
     * パラメータ数を取得.
     * <BR><BR>
     * 対象のパラメータ数を取得します.
     * <BR>
     * @return int パラメータ数が返されます.
     */
    public int size() ;
    
    /**
     * パラメータ数を取得.
     * <BR><BR>
     * 対象のパラメータ数を取得します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @return int パラメータ数が返されます.
     */
    public int size( String key ) ;
    
    /**
     * キー名群を取得.
     * <BR><BR>
     * 対象のキー名群を取得します.
     * <BR>
     * @return String[] キー名群が返されます.
     */
    public String[] getKeys() ;
    
    /**
     * Iteratorを取得.
     * @return Iterator Iteratorが返されます.
     */
    public Iterator iterator() ;
    
    /**
     * 指定キーが存在するかチェック.
     * <BR><BR>
     * 指定キーが存在するかチェックします.
     * <BR>
     * @param key 対象のキー名を取得します.
     * @return boolean [true]の場合、存在します.
     */
    public boolean isKey( String key ) ;
    
    /**
     * KeepAlive情報を取得.
     * <BR><BR>
     * KeepAlive情報を取得します.
     * <BR>
     * @return long KeepAlive情報が返されます.<BR>
     *              [-1L]が返された場合、KeepAlive情報は存在しません.
     */
    public long getKeepAlive() ;
    
    /**
     * コネクションヘッダにKeepAliveが存在するかチェック.
     * <BR><BR>
     * コネクションヘッダにKeepAliveが存在するかチェックします.
     * <BR>
     * @return boolean [true]の場合、KeepAliveが存在します.
     */
    public boolean isKeepAlive() ;
}

