package org.maachang.comet.httpd ;

import java.io.InputStream;

import org.maachang.comet.httpd.engine.session.HttpdSession;
import org.maachang.comet.net.nio.ConnectionInfo;
import org.maachang.util.BaseRandom;


/**
 * HTTPDリクエスト.
 *
 * @version 2007/08/20
 * @author  masahito suzuki
 * @since   MaachangComet 1.00
 */
public interface HttpdRequest {
    
    /**
     * オブジェクトを複製.
     * @return HttpdRequest 複製されたオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public HttpdRequest copy() throws Exception ;
    
    /**
     * HTTPメソッドを設定.
     * <BR><BR>
     * HTTPメソッドを設定します.
     * <BR>
     * @param method HTTPメソッドを設定します.
     */
    public void setMethod( String method ) ;
    
    /**
     * HTTPメソッドを取得.
     * <BR><BR>
     * HTTPメソッドを取得します.
     * <BR>
     * @return String HTTPメソッドが返されます.
     */
    public String getMethod() ;
    
    /**
     * HTTPバージョンを設定.
     * <BR><BR>
     * HTTPバージョンを設定します.
     * <BR>
     * @param httpVersion HTTPバージョンが返されます.<BR>
     *                    [HTTP/0.9]の場合は、HTTPバージョン0.9です.<BR>
     *                    [HTTP/1.0]の場合は、HTTPバージョン1.0です.<BR>
     *                    [HTTP/1.1]の場合は、HTTPバージョン1.1です.
     */
    public void setHttpVersion( String httpVersion ) ;
    
    /**
     * HTTPバージョンを取得.
     * <BR><BR>
     * HTTPバージョンを取得します.
     * <BR>
     * @return String HTTPバージョンが返されます.
     *                [HTTP/0.9]の場合は、HTTPバージョン0.9です.<BR>
     *                [HTTP/1.0]の場合は、HTTPバージョン1.0です.<BR>
     *                [HTTP/1.1]の場合は、HTTPバージョン1.1です.
     */
    public String getHttpVersion() ;
    
    /**
     * HTTPバージョン番号を取得.
     * <BR><BR>
     * HTTPバージョン番号を取得します.
     * <BR>
     * @return String HTTPバージョン番号が返されます.
     */
    public String getVersion() ;
    
    /**
     * URL相対パスを設定.
     * <BR><BR>
     * URL相対パスを設定します.
     * <BR>
     * @param urlPath URL相対パスを設定します.
     */
    public void setUrlPath( String urlPath ) ;
    
    /**
     * URL相対パスを取得.
     * <BR><BR>
     * URL相対パスを取得します.
     * <BR>
     * @return String URL相対パスが返されます.
     */
    public String getUrlPath() ;
    
    /**
     * リモートアドレスを取得.
     * <BR><BR>
     * リモートアドレスが返されます.
     * <BR>
     * @return String リモートアドレスが返されます.
     */
    public String getRemoteAddress() ;
    
    /**
     * リモートポート番号を取得.
     * <BR><BR>
     * リモートポート番号が返されます.
     * <BR>
     * @return int リモートポート番号が返されます.
     */
    public int getRemotePort() ;
    
    /**
     * クエリオブジェクトを取得.
     * <BR><BR>
     * クエリオブジェクトを取得します.
     * <BR>
     * @return HttpdParams クエリオブジェクトが返されます.
     */
    public HttpdParams getQuery() ;
    
    /**
     * ヘッダオブジェクトを取得.
     * <BR><BR>
     * ヘッダオブジェクトを取得します.
     * <BR>
     * @return HttpdHeaders ヘッダオブジェクトが返されます.
     */
    public HttpdHeaders getHeader() ;
    
    /**
     * このリクエストに対するセッションオブジェクトを取得.
     * <BR><BR>
     * このリクエストに対するセッションオブジェクトが返されます.
     * <BR>
     * @return HttpdSession セッション情報が返されます.
     * @exception Exceptino 例外.
     */
    public HttpdSession getSession()
        throws Exception ;
    
    /**
     * HTTPBody情報を取得.
     * <BR><BR>
     * HTTPBody情報を取得します.
     * <BR>
     * @return InputStream HTTPBody情報が返されます.
     */
    public InputStream getBody() ;
    
    /**
     * HTTPBody情報を取得.
     * <BR><BR>
     * HTTPBody情報を取得します.
     * <BR>
     * @return byte[] HTTPBody情報が返されます.
     */
    public byte[] getBodyByBinary() ;
    
    /**
     * HTTPBody情報を設定.
     * <BR><BR>
     * HTTPBody情報を設定します.
     * <BR>
     * @param body 対象のHTTPBody情報を設定します.
     */
    public void setBody( byte[] body ) ;
    
    /**
     * コネクション情報を取得.
     * <BR><BR>
     * コネクション情報を取得します.
     * <BR>
     * @param ConnectionInfo 対象のコネクション情報が返されます.
     */
    public ConnectionInfo getConnectionInfo() ;
    
    /**
     * KeepAliveタイムアウトを設定.
     * <BR><BR>
     * KeepAliveタイムアウトを設定します.
     * <BR>
     * @param timeout 対象のKeepAliveタイムアウト値を設定します.
     */
    public void setKeepAliveTimeout( int timeout ) ;
    
    /**
     * KeepAliveタイムアウトを取得.
     * <BR><BR>
     * KeepAliveタイムアウトを取得します.
     * <BR>
     * @return long KeepAliveタイムアウト値が返されます.
     */
    public long getKeepAliveTimeout() ;
    
    /**
     * KeepAliveカウントを取得.
     * <BR><BR>
     * KeepAliveカウントを取得します.
     * <BR>
     * @return int KeepAliveカウント値が返されます.
     */
    public int getKeepAliveCount() ;
    
    /**
     * ランダムオブジェクトを取得.
     * @return BaseRandom ランダムオブジェクトが返されます.
     */
    public BaseRandom getRandom() ;
    
    /**
     * GZIP圧縮を許可するか設定.
     * <BR><BR>
     * MaachangCometがGZIP圧縮を許可している場合[true]を設定します.
     * <BR>
     * @param flag [true]の場合、GZIP圧縮を許可します.
     */
    public void setGzip( boolean flag ) ;
    
    /**
     * GZIP圧縮を許可しているかチェック.
     * <BR><BR>
     * MaachangCometがGZIP圧縮を許可しているかチェックします.
     * <BR>
     * @return boolean [true]の場合、許可されています.
     */
    public boolean isGzip() ;
    
    /**
     * Cookieが存在するかチェック.
     * <BR><BR>
     * Cookieが存在するかチェックします.
     * <BR>
     * @return boolean [true]の場合、Cookieが存在します.
     */
    public boolean isCookie() ;
    
    /**
     * 対象プロトコルがSSLであるかチェック.
     * <BR><BR>
     * 対象プロトコルがSSLであるかチェックします.
     * <BR>
     * @return boolean [true]の場合、プロトコルはSSLです.
     */
    public boolean isSsl() ;
    
    /**
     * このリクエストが有効かチェック.
     * <BR><BR>
     * このリクエストが有効かチェックします.
     * <BR>
     * @return [true]が返された場合、有効です.
     */
    public boolean isUse() ;
}
