package org.maachang.comet.httpd.engine;

import org.maachang.comet.ServiceDef;
import org.maachang.comet.httpd.HttpdErrorDef;
import org.maachang.comet.httpd.HttpdHeaders;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.HttpdResponse;
import org.maachang.comet.httpd.engine.errors.HttpdErrorPageManager;
import org.maachang.manager.GlobalManager;

/**
 * エラーページを出力.
 * 
 * @version 2007/08/19
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public class WriteError {
    
    /**
     * エラーページを出力.
     * <BR><BR>
     * 指定条件を指定してエラーページを出力します.
     * <BR>
     * @param request リクエスト情報を設定します.
     * @param response レスポンス情報を設定します.
     * @param header 追加対象のヘッダを設定します.
     * @param state 対象のエラーステータスを設定します.
     * @param detail 対象のエラー詳細メッセージを設定します.
     * @exception Exception 例外.
     */
    public static final void output( HttpdRequest request,HttpdResponse response,HttpdHeaders header,int state,String detail )
        throws Exception {
        try {
            byte[] bin = getErrorPage( request.getUrlPath(),state,detail ) ;
            if( bin != null ) {
                HttpdResponse res = response.create( request,request.getUrlPath(),state,
                    request.getKeepAliveTimeout(),request.getKeepAliveCount() ) ;
                res.setHttpCache( true ) ;
                res.setHttpClose( true ) ;
                res.setGzip( true ) ;
                res.setCookieSession( request ) ;
                int len = bin.length ;
                if( header != null ) {
                    res.getHeader().add( header ) ;
                }
                res.getHeader().addHeader( HttpdDef.VALUE_CONTENT_TYPE,HttpdDef.ERROR_PAGE_MIME_TYPE ) ;
                res.getOutput().write( bin,0,len ) ;
                res.flush() ;
                res.flushAndClose() ;
            }
        } catch( Exception e ) {
        }
    }
    
    /**
     * エラーページを取得.
     */
    private static final byte[] getErrorPage( String url,int code,String detail ) {
        HttpdErrorPageManager errors = ( HttpdErrorPageManager )GlobalManager.getValue(
            ServiceDef.MANAGER_BY_ERROR_PAGE ) ;
        byte[] ret = null ;
        String error = null ;
        try {
            error = errors.getErrorPage( url,code,HttpdErrorDef.convertErrorMessage( code ),detail ) ;
            if( error != null ) {
                try {
                    ret = error.getBytes( HttpdDef.DEF_CHARSET_HTML ) ;
                } catch( Exception ee ) {
                    error = null ;
                    ret = null ;
                }
            }
        } catch( Exception e ) {
            error = null ;
            ret = null ;
        }
        if( ret == null ) {
            try {
                error = errors.getDefaultErrorPage( url,code,HttpdErrorDef.convertErrorMessage( code ),detail ) ;
                if( error != null ) {
                    ret = error.getBytes( HttpdDef.DEF_CHARSET_HTML ) ;
                }
            } catch( Exception e ) {
                error = null ;
                ret = null ;
            }
        }
        if( ret == null ) {
            return null ;
        }
        return ret ;
    }
    
}
