package org.maachang.comet.httpd.engine.script;

/**
 * 行区切りスクリプト要素.
 * 
 * @version 2008/08/15
 * @author masahito suzuki
 * @since MaachangComet 1.24
 */
public class SrcScriptList {
    
    /**
     * 対象ファイル名.
     */
    private String name = null ;
    
    /**
     * 開始行番号.
     */
    private int start = -1 ;
    
    /**
     * 行数.
     */
    private int length = -1 ;
    
    /**
     * コンストラクタ.
     */
    public SrcScriptList() {
        
    }
    
    /**
     * コンストラクタ.
     * @param name ファイル名を設定します.
     * @param start 開始行番号を設定します.
     * @param length 全体行数を設定します.
     */
    public SrcScriptList( String name,int start,int length ) {
        this.name = name ;
        this.start = start ;
        this.length = length ;
    }

    /**
     * length を取得.
     * <BR><BR>
     * @return length が返されます.
     */
    public int getLength() {
        return length;
    }

    /**
     * length を設定.
     * <BR><BR>
     * @param length length を設定します.
     */
    public void setLength(int length) {
        this.length = length;
    }

    /**
     * name を取得.
     * <BR><BR>
     * @return name が返されます.
     */
    public String getName() {
        return name;
    }

    /**
     * name を設定.
     * <BR><BR>
     * @param name name を設定します.
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * start を取得.
     * <BR><BR>
     * @return start が返されます.
     */
    public int getStart() {
        return start;
    }

    /**
     * start を設定.
     * <BR><BR>
     * @param start start を設定します.
     */
    public void setStart(int start) {
        this.start = start;
    }
    
    /**
     * 終了行値取得.
     * @return int 終了行値が返されます.
     */
    public int getEnd() {
        return this.start + this.length ;
    }
}
