package org.maachang.comet.httpd.engine.script.js ;

import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.util.atomic.AtomicOBJECT;

/**
 * 初期化スクリプト管理.
 * 
 * @version 2007/11/28
 * @author masahito suzuki
 * @since MaachangComet 1.02
 */
public class InitJS {
    
    /**
     * シングルトン.
     */
    private static final InitJS SNGL = new InitJS() ;
    
    /**
     * InitJavaScriptデータ.
     */
    private final AtomicOBJECT<String> initJs = new AtomicOBJECT<String>() ;
    
    /**
     * コンストラクタ.
     */
    private InitJS() {}
    
    /**
     * オブジェクトを取得.
     */
    public static final InitJS getInstance() {
        return SNGL ;
    }
    
    private void load() throws Exception {
        this.initJs.set( ScriptDef.getScriptByResource( "org/maachang/comet/httpd/engine/script/js/initJS.js" ) ) ;
    }
    
    /**
     * 初期化スクリプトを取得.
     * @return String 初期化スクリプトが返されます.
     * @exception Exception 例外.
     */
    public String get() throws Exception {
        if( initJs.get() == null ) {
            load() ;
        }
        return initJs.get() ;
    }
}
