// model実装.
//

////////////////////////////////////////////////////////////////////////////////
// BaseModel.
////////////////////////////////////////////////////////////////////////////////

// 楽観的ロック例外.
var OptimisticLockException = function(message){
    if( useString( message ) ) {
        this.message = message;
    }
    else {
        this.message = "";
    }
};
OptimisticLockException.prototype = new IOException;
OptimisticLockException.prototype.name = 'OptimisticLockException';

// 基本モデルオブジェクト.
baseModel = function(modelName) {
    if( isNull( modelName ) ) {
        return null ;
    }
    modelName = trim( modelName ) ;
    // modelを有効にする.
    if( create_base_model() == false ) {
        return null ;
    }
    
    // model用データ格納条件.
    var baseMap = new java.util.HashMap() ;
    
    // インスタンス生成用.
    baseMap.put( "bean",
        function( map ) {
            if( script_model().isCreate() == false ) {
                create_base_model() ;
                if( script_model().isCreate() == false ) {
                    return null ;
                }
            }
            var meta = script_model().getMeta(modelName) ;
            var len = meta.size() ;
            var ret = {} ;
            for( var i = 0 ; i < len ; i ++ ) {
                var key = meta.getColumnName( true,i ) ;
                // IDは処理しないようにする.
                if( key != "id" ) {
                    ret[ key ] = "" ;
                }
            }
            // デフォルト値が存在する場合は、それをbeanに設定する.
            if( isNull( this.defaultColumns ) == false ) {
                var df = this.defaultColumns ;
                for( var k in df ) {
                    ret[k] = df[k] ;
                }
            }
            // map情報が渡された場合、
            if( isNull( map ) == false && valueof( map ) == 'map' ) {
                for( var i = 0 ; i < len ; i ++ ) {
                    var tName = meta.getColumnName( true,i ) ;
                    // IDは処理しないようにする.
                    if( tName == "id" ) {
                        continue ;
                    }
                    var type = SqlType.typeOf( meta.getColumnType( i ) ) ;
                    // 日付情報の場合.
                    if( tName != "CreateTime" && tName != "UpdateTime" &&
                        ( type == "date" || type == "timestamp" ) &&
                        ( isEmpty( map[tName+"Year"] ) == false &&
                            isEmpty( map[tName+"Month"] ) == false &&
                            isEmpty( map[tName+"Day"] ) ) == false ) {
                        ret[ tName ] = convertMapByDate( tName,map ) ;
                    }
                    else {
                        var p = map[ tName ] ;
                        if( isEmpty( p ) == false ) {
                            var pType = valueof( p ) ;
                            // booleanの場合.
                            if( type == "boolean" ) {
                                if( pType == "boolean" ) {
                                    ret[ tName ] = p ;
                                }
                                else {
                                    p = p.toLowerCase() ;
                                    if( p == "true" ) {
                                        ret[ tName ] = true ;
                                    }
                                    else if( p == "false" ) {
                                        ret[ tName ] = false ;
                                    }
                                }
                            }
                            // 整数の場合.
                            else if( type == "integer" || type == "long" ) {
                                if( pType == "number" ) {
                                    ret[ tName ] = p ;
                                }
                                else {
                                    ret[ tName ] = parseInt( p ) ;
                                }
                            }
                            // 日付の場合.
                            else if( type == "date" || type == "timestamp" || type == "time" ) {
                                if( pType == "date" ) {
                                    ret[ tName ] = p ;
                                }
                                else {
                                    ret[ tName ] = new Date( p ) ;
                                }
                            }
                            // 上記以外の内容.
                            else {
                                ret[ tName ] = p ;
                            }
                        }
                    }
                }
            }
            return ret ;
        }
    ) ;
    
    // インスタンス生成用.
    baseMap.put( "copy",
        function( src,dest ) {
            if( isNull( src ) || valueof( src ) != 'map' ||
                isNull( dest ) || valueof( dest ) != 'map' ) {
                return false ;
            }
            if( script_model().isCreate() == false ) {
                create_base_model() ;
                if( script_model().isCreate() == false ) {
                    return false ;
                }
            }
            var meta = script_model().getMeta(modelName) ;
            var len = meta.size() ;
            for( var i = 0 ; i < len ; i ++ ) {
                var tName = meta.getColumnName( true,i ) ;
                // IDは処理しないようにする.
                if( tName == "id" ) {
                    continue ;
                }
                var type = SqlType.typeOf( meta.getColumnType( i ) ) ;
                // 日付情報の場合.
                if( tName != "CreateTime" && tName != "UpdateTime" &&
                    ( type == "date" || type == "timestamp" ) &&
                    ( isNull( src[tName+"Year"] ) == false &&
                        isNull( src[tName+"Month"] ) == false &&
                        isNull( src[tName+"Day"] ) == false ) ) {
                    dest[ tName ] = convertMapByDate( tName,src ) ;
                }
                else {
                    var p = src[ tName ] ;
                    if( isEmpty( p ) == false ) {
                        var pType = typeof( p ) ;
                        // 情報が存在しない場合は処理しない.
                        if( pType == "string" && useString( p ) == false ) {
                            continue ;
                        }
                        // booleanの場合.
                        if( type == "boolean" ) {
                            if( pType == "boolean" ) {
                                dest[ tName ] = p ;
                            }
                            else {
                                p = p.toLowerCase() ;
                                if( p == "true" ) {
                                    dest[ tName ] = true ;
                                }
                                else if( p == "false" ) {
                                    dest[ tName ] = false ;
                                }
                            }
                        }
                        // 整数の場合.
                        else if( type == "integer" || type == "long" ) {
                            if( pType == "number" ) {
                                dest[ tName ] = p ;
                            }
                            else {
                                dest[ tName ] = parseInt( p ) ;
                            }
                        }
                        // 日付の場合.
                        else if( type == "date" || type == "timestamp" || type == "time" ) {
                            if( pType == "date" ) {
                                dest[ tName ] = p ;
                            }
                            else {
                                dest[ tName ] = new Date( p ) ;
                            }
                        }
                        // 上記以外の内容.
                        else {
                            dest[ tName ] = p ;
                        }
                    }
                }
            }
            return true ;
        }
    ) ;
    
    // カラム名一覧を取得.
    baseMap.put( "columns",
        function(mode) {
            if( script_model().isCreate() == false ) {
                create_base_model() ;
                if( script_model().isCreate() == false ) {
                    return null ;
                }
            }
            var meta = script_model().getMeta(modelName) ;
            var ret = [] ;
            var len = meta.size() ;
            if( isNull( mode ) == false && mode == true ) {
                for( var i = 0 ; i < len ; i ++ ) {
                    ret[ ret.length ] = { "name": meta.getColumnName( true,i ),
                        "type":meta.meta.getColumnType( i ) } ;
                }
            }
            else {
                for( var i = 0 ; i < len ; i ++ ) {
                    ret[ ret.length ] = meta.getColumnName( true,i ) ;
                }
            }
            return ret ;
        }
    ) ;
            
    // 保存用.
    baseMap.put( "save",
        function(params) {
            if( script_model().isType == false ) {
                return false ;
            }
            if( script_model().isCreate() == false ) {
                create_base_model() ;
                if( script_model().isCreate() == false ) {
                    return false ;
                }
            }
            if( isNull( params ) ) {
                return false ;
            }
            var time = null ;
            if( script_model().isDebug() == true ) {
                time = new Date().getTime() ;
            }
            var map = SubModel.convertParamByMap( params ) ;
            if( isNull( map ) || map.size() <= 0 ) {
                return false ;
            }
            SubModel.removeManyColumn( map ) ;
            var insertFlag = false ;
            var res = script_model().save( modelName,map ) ;
            if( res <= -1 ) {
                // 楽観的ロック例外.
                throw new OptimisticLockException( "楽観的ロック例外を検知" ) ;
            }
            if( isNull( params[SubModel.COLUMN_ID] ) && res != null && typeof(res) == "object" ) {
                if( res instanceof java.lang.Long ) {
                    params[SubModel.COLUMN_ID]= res ;
                    insertFlag = true ;
                }
            }
            var createAt = map.get( SubModel.COLUMN_CREATE_TIME ) ;
            var updateAt = map.get( SubModel.COLUMN_UPDATE_TIME ) ;
            var versionValue = map.get( SubModel.COLUMN_OPTIMISTIC_LOCK ) ;
            if( createAt != null && insertFlag == true ) {
                params[SubModel.COLUMN_CREATE_TIME] = new Date( createAt.getTime() ) ;
            }
            if( updateAt != null ) {
                params[SubModel.COLUMN_UPDATE_TIME] = new Date( updateAt.getTime() ) ;
            }
            if( versionValue != null ) {
                params[SubModel.COLUMN_OPTIMISTIC_LOCK] = convertString( versionValue ) ;
            }
            if( script_model().isDebug() == true ) {
                debugLog( "## [" + ( new Date().getTime() - time ) + "ms]" ) ;
            }
            // 更新通知.
            script_model().setUpdateOrDeleteTable( modelName ) ;
            return true ;
        }
    ) ;
    // 指定更新用.
    baseMap.put( "update",
        function(where,params) {
            if( script_model().isType == false ) {
                return false ;
            }
            if( script_model().isCreate() == false ) {
                create_base_model() ;
                if( script_model().isCreate() == false ) {
                    return false ;
                }
            }
            if( isNull( where ) ) {
                where = "" ;
            }
            else {
                where = SubModel.trimWhere( where,modelName ) ;
            }
            if( isNull( params ) ) {
                params = null ;
            }
            else if( valueof( params ) != "array" ) {
                params = [ params ] ;
            }
            var time = null ;
            if( script_model().isDebug() == true ) {
                time = new Date().getTime() ;
            }
            var list = null ;
            if( params != null ) {
                list = SubModel.convertParamByList( params ) ;
                if( isNull( list ) || list.size() <= 0 ) {
                    list = null ;
                }
            }
            script_model().update( modelName,where,list ) ;
            if( script_model().isDebug() == true ) {
                debugLog( "## [" + ( new Date().getTime() - time ) + "ms]" ) ;
            }
            // 更新通知.
            script_model().setUpdateOrDeleteTable( modelName ) ;
            return true ;
        }
    ) ;
    // 指定削除用(Join).
    baseMap.put( "rjfind",
        function(where,params) {
            return baseMap.get( "removeFind" )( where,params,true ) ;
        }
    ) ;
    // 指定削除用(Join).
    baseMap.put( "removeFindJoin",
        function(where,params) {
            return baseMap.get( "removeFind" )( where,params,true ) ;
        }
    ) ;
    // 指定削除用.
    baseMap.put( "rfind",
        function(where,params) {
            return baseMap.get( "removeFind" )( where,params,false ) ;
        }
    ) ;
    // 指定削除用.
    baseMap.put( "removeFind",
        function(where,params,join) {
            if( script_model().isType == false ) {
                return false ;
            }
            if( script_model().isCreate() == false ) {
                create_base_model() ;
                if( script_model().isCreate() == false ) {
                    return false ;
                }
            }
            if( isNull( where ) ) {
                where = "" ;
            }
            else {
                where = SubModel.trimWhere( where,modelName ) ;
                if( where.length > 0 && startsWith( where.toLowerCase(),"where " ) == false ) {
                    where = "where " + where ;
                }
            }
            if( isNull( params ) ) {
                params = null ;
            }
            else if( valueof( params ) != "array" ) {
                params = [ params ] ;
            }
            var time = null ;
            if( script_model().isDebug() == true ) {
                time = new Date().getTime() ;
            }
            var list = null ;
            if( params != null ) {
                list = SubModel.convertParamByList( params ) ;
                if( isNull( list ) || list.size() <= 0 ) {
                    list = null ;
                }
            }
            var joinMap = null ;
            if( join == true ) {
                joinMap = SubModel.getModelBySrcJoinKeys( modelName,baseMap ) ;
            }
            script_model().remove( modelName,joinMap,where,list ) ;
            if( script_model().isDebug() == true ) {
                debugLog( "## [" + ( new Date().getTime() - time ) + "ms]" ) ;
            }
            // 更新通知.
            script_model().setUpdateOrDeleteTable( modelName ) ;
            return true ;
        }
    ) ;
    // 削除用(Join).
    baseMap.put( "removeJoin",
        function(params) {
            return baseMap.get( "remove" )( params,true ) ;
        }
    ) ;
    // 削除用(Join).
    baseMap.put( "removej",
        function(params) {
            return baseMap.get( "remove" )( params,true ) ;
        }
    ) ;
    // 削除用
    baseMap.put( "remove",
        function(params,join) {
            if( script_model().isType == false ) {
                return false ;
            }
            if( script_model().isCreate() == false ) {
                create_base_model() ;
                if( script_model().isCreate() == false ) {
                    return false ;
                }
            }
            if( isNull( params ) ) {
                return false ;
            }
            var time = null ;
            if( script_model().isDebug() == true ) {
                time = new Date().getTime() ;
            }
            var map = SubModel.convertParamByMap( params ) ;
            if( isNull( map ) || map.size() <= 0 ) {
                return false ;
            }
            SubModel.removeManyColumn( map ) ;
            var joinMap = null ;
            if( join == true ) {
                joinMap = SubModel.getModelBySrcJoinKeys( modelName,baseMap ) ;
            }
            script_model().removeData( modelName,joinMap,map ) ;
            if( script_model().isDebug() == true ) {
                debugLog( "## [" + ( new Date().getTime() - time ) + "ms]" ) ;
            }
            // 更新通知.
            script_model().setUpdateOrDeleteTable( modelName ) ;
            return true ;
        }
    ) ;
    // 指定取得用(Join).
    baseMap.put( "findJoin",
        function(where,params,sort) {
            return baseMap.get( "find" )( where,params,sort,true,false ) ;
        }
    ) ;
    // 指定取得用(Many).
    baseMap.put( "findMany",
        function(where,params,sort) {
            return baseMap.get( "find" )( where,params,sort,false,true ) ;
        }
    ) ;
    // 指定取得用.
    baseMap.put( "find",
        function(where,params,sort,join,many) {
            if( script_model().isType == false ) {
                return null ;
            }
            if( script_model().isCreate() == false ) {
                create_base_model() ;
                if( script_model().isCreate() == false ) {
                    return null ;
                }
            }
            if( useString( where ) == false ) {
                where = "" ;
            }
            else {
                where = SubModel.trimWhere( where,modelName ) ;
                if( where.length > 0 && startsWith( where.toLowerCase(),"where " ) == false ) {
                    where = "where " + where ;
                }
            }
            if( isNull( params ) ) {
                params = null ;
            }
            else if( valueof( params ) != "array" ) {
                params = [ params ] ;
            }
            var time = null ;
            if( script_model().isDebug() == true ) {
                time = new Date().getTime() ;
            }
            var list = null ;
            if( params != null ) {
                list = SubModel.convertParamByList( params ) ;
                if( isNull( list ) || list.size() <= 0 ) {
                    list = null ;
                }
            }
            var joinMap = null ;
            if( join == true ) {
                joinMap = SubModel.getModelByJoinKeys( baseMap ) ;
                many = false ;
            }
            var manyMap = null ;
            if( many == true ) {
                manyMap = SubModel.getModelBySrcJoinKeys( modelName,baseMap ) ;
            }
            if( isNull( sort ) == false && ( sort = trim( sort ) ).length > 0 ) {
                if( startsWith( sort.toLowerCase(),"order by" ) == false ) {
                    sort = "order by "+sort ;
                }
                where += " " + sort ;
            }
            var ret = script_model().find( modelName,joinMap,manyMap,where,list ) ;
            ret = SubModel.convertResultByJList( ret ) ;
            if( script_model().isDebug() == true ) {
                debugLog( "## [" + ( new Date().getTime() - time ) + "ms]" ) ;
            }
            return ret ;
        }
    ) ;
    // 指定取得用(Join).
    baseMap.put( "limitJoin",
        function(offset,limit,where,params,sort) {
            return baseMap.get( "limit" )( offset,limit,where,params,sort,true ) ;
        }
    ) ;
    // 指定取得用(リミット指定).
    baseMap.put( "limit",
        function(offset,limit,where,params,sort,join ) {
            if( script_model().isType == false ) {
                return null ;
            }
            if( script_model().isCreate() == false ) {
                create_base_model() ;
                if( script_model().isCreate() == false ) {
                    return null ;
                }
            }
            if( isNull( offset ) ) {
                offset = 0 ;
            }
            if( isNull( limit ) ) {
                limit = -1 ;
            }
            if( useString( where ) == false ) {
                where = "" ;
            }
            else {
                where = SubModel.trimWhere( where,modelName ) ;
                if( where.length > 0 && startsWith( where.toLowerCase(),"where " ) == false ) {
                    where = "where " + where ;
                }
            }
            if( isNull( params ) ) {
                params = null ;
            }
            else if( valueof( params ) != "array" ) {
                params = [ params ] ;
            }
            var time = null ;
            if( script_model().isDebug() == true ) {
                time = new Date().getTime() ;
            }
            var list = null ;
            if( params != null ) {
                list = SubModel.convertParamByList( params ) ;
                if( isNull( list ) || list.size() <= 0 ) {
                    list = null ;
                }
            }
            var joinMap = null ;
            if( join == true ) {
                joinMap = SubModel.getModelByJoinKeys( baseMap ) ;
            }
            if( isNull( sort ) == false && ( sort = trim( sort ) ).length > 0 ) {
                if( startsWith( sort.toLowerCase(),"order by" ) == false ) {
                    sort = "order by "+sort ;
                }
                where += " " + sort ;
            }
            var ret = script_model().limit( modelName,joinMap,offset,limit,where,list ) ;
            ret = SubModel.convertResultByJList( ret ) ;
            if( script_model().isDebug() == true ) {
                debugLog( "## [" + ( new Date().getTime() - time ) + "ms]" ) ;
            }
            return ret ;
        }
    ) ;
    // 指定取得用(最初の１件目だけを取得)(Join).
    baseMap.put( "firstJoin",
        function(where,params,sort) {
            return baseMap.get( "first" )( where,params,sort,true,false ) ;
        }
    ) ;
    // 指定取得用(最初の１件目だけを取得)(Many).
    baseMap.put( "firstMany",
        function(where,params,sort) {
            return baseMap.get( "first" )( where,params,sort,false,true ) ;
        }
    ) ;
    // 指定取得用(最初の１件目だけを取得).
    baseMap.put( "first",
        function(where,params,sort,join,many) {
            if( script_model().isType == false ) {
                return null ;
            }
            if( script_model().isCreate() == false ) {
                create_base_model() ;
                if( script_model().isCreate() == false ) {
                    return null ;
                }
            }
            if( isNull( where ) ) {
                where = "" ;
            }
            else {
                where = SubModel.trimWhere( where,modelName ) ;
                if( where.length > 0 && startsWith( where.toLowerCase(),"where " ) == false ) {
                    where = "where " + where ;
                }
            }
            if( isNull( params ) ) {
                params = null ;
            }
            else if( valueof( params ) != "array" ) {
                params = [ params ] ;
            }
            var time = null ;
            if( script_model().isDebug() == true ) {
                time = new Date().getTime() ;
            }
            var list = null ;
            if( params != null ) {
                list = SubModel.convertParamByList( params ) ;
                if( isNull( list ) || list.size() <= 0 ) {
                    list = null ;
                }
            }
            var joinMap = null ;
            if( join == true ) {
                joinMap = SubModel.getModelByJoinKeys( baseMap ) ;
            }
            var manyMap = null ;
            if( many == true ) {
                manyMap = SubModel.getModelBySrcJoinKeys( modelName,baseMap ) ;
            }
            if( isNull( sort ) == false && ( sort = trim( sort ) ).length > 0 ) {
                if( startsWith( sort.toLowerCase(),"order by" ) == false ) {
                    sort = "order by "+sort ;
                }
                where += " " + sort ;
            }
            var ret = script_model().first( modelName,joinMap,manyMap,where,list ) ;
            ret = SubModel.convertResultByJList( ret ) ;
            if( script_model().isDebug() == true ) {
                debugLog( "## [" + ( new Date().getTime() - time ) + "ms]" ) ;
            }
            return ret ;
        }
    ) ;
    // 指定数取得.
    baseMap.put( "read",
        function(where,params,sort) {
            if( script_model().isType == false ) {
                return null ;
            }
            if( script_model().isCreate() == false ) {
                create_base_model() ;
                if( script_model().isCreate() == false ) {
                    return null ;
                }
            }
            if( isNull( where ) ) {
                where = "" ;
            }
            else {
                where = SubModel.trimWhere( where,modelName ) ;
                if( where.length > 0 && startsWith( where.toLowerCase(),"where " ) == false ) {
                    where = "where " + where ;
                }
            }
            if( isNull( params ) ) {
                params = null ;
            }
            else if( valueof( params ) != "array" ) {
                params = [ params ] ;
            }
            var time = null ;
            if( script_model().isDebug() == true ) {
                time = new Date().getTime() ;
            }
            var list = null ;
            if( params != null ) {
                list = SubModel.convertParamByList( params ) ;
                if( isNull( list ) || list.size() <= 0 ) {
                    list = null ;
                }
            }
            if( isNull( sort ) == false && ( sort = trim( sort ) ).length > 0 ) {
                if( startsWith( sort.toLowerCase(),"order by" ) == false ) {
                    sort = "order by "+sort ;
                }
                where += " " + sort ;
            }
            var rline = script_model().readLine( modelName,where,list ) ;
            if( script_model().isDebug() == true ) {
                debugLog( "## [" + ( new Date().getTime() - time ) + "ms]" ) ;
            }
            var ret = new SubModel.resultLine() ;
            ret.create( rline ) ;
            return ret ;
        }
    ) ;
    // 指定数取得.
    baseMap.put( "count",
        function(where,params) {
            if( script_model().isType == false ) {
                return 0 ;
            }
            if( script_model().isCreate() == false ) {
                create_base_model() ;
                if( script_model().isCreate() == false ) {
                    return 0 ;
                }
            }
            if( isNull( where ) ) {
                where = "" ;
            }
            else {
                where = SubModel.trimWhere( where,modelName ) ;
                if( where.length > 0 && startsWith( where.toLowerCase(),"where " ) == false ) {
                    where = "where " + where ;
                }
            }
            if( isNull( params ) ) {
                params = null ;
            }
            else if( valueof( params ) != "array" ) {
                params = [ params ] ;
            }
            var time = null ;
            if( script_model().isDebug() == true ) {
                time = new Date().getTime() ;
            }
            var list = null ;
            if( params != null ) {
                list = SubModel.convertParamByList( params ) ;
                if( isNull( list ) || list.size() <= 0 ) {
                    list = null ;
                }
            }
            var ret = script_model().count( modelName,where,list ) ;
            if( script_model().isDebug() == true ) {
                debugLog( "## [" + ( new Date().getTime() - time ) + "ms]" ) ;
            }
            return parseValue( ret ) ;
        }
    ) ;
    // missing_method対応.
    return JSAdapter({
        __get__ : function (name) {
            if( isNull( name ) ) {
                return null ;
            }
            if( baseMap.containsKey( name ) ) {
                return baseMap.get( name ) ;
            }
            var missing = null ;
            var pms = name.split( "_" ) ;
            if( pms.length >= 3 ) {
                if( pms[ 1 ].toLowerCase() == "by" ) {
                    var funcName = pms[ 0 ].toLowerCase() ;
                    if( funcName == "find" || funcName == "removefind" ||
                        funcName == "first" || funcName == "count" ||
                        funcName == "findjoin" ||
                        funcName == "rfind" || funcName == "rjfind" || funcName == "removefindjoin" ||
                        funcName == "firstjoin" || funcName == "findmany" ||
                        funcName == "firstmany" ||
                        funcName == "read" ) {
                        missing = function(params,sort) {
                            if( isNull( params ) ) {
                                params = null ;
                            }
                            var where = "" ;
                            var len = pms.length ;
                            for( var i = 2 ; i < len ; i ++ ) {
                                var columnName = org.maachang.dao.dbms.DbUtil.convertJavaNameByDBName( pms[ i ] ) ;
                                pms[ i ] = pms[ i ].toLowerCase() ;
                                if( ( i & 0x00000001 ) == 0 ) {
                                    //if( pms[ i ] == "and" || pms[ i ] == "or" ) {
                                    if( pms[ i ] == "and" ) {
                                        return false ;
                                    }
                                    where += " $"+columnName+"=?" ;
                                }
                                else {
                                    //if( pms[ i ] == "and" || pms[ i ] == "or" ) {
                                    if( pms[ i ] == "and" ) {
                                        where += " " + pms[ i ] ;
                                    }
                                    else {
                                        return false ;
                                    }
                                }
                            }
                            if( funcName == "removefind" ) {
                                funcName = "removeFind" ;
                            }
                            else if( funcName == "rfind" ) {
                                funcName = "rfind" ;
                            }
                            else if( funcName == "rjfind" ) {
                                funcName = "rjfind" ;
                            }
                            else if( funcName == "removefindjoin" ) {
                                funcName = "removeFindJoin" ;
                            }
                            else if( endsWith( funcName,"join" ) ) {
                                funcName = funcName.substring( 0,funcName.length - "join".length ) + "Join" ;
                            }
                            else if( endsWith( funcName,"many" ) ) {
                                funcName = funcName.substring( 0,funcName.length - "many".length ) + "Many" ;
                            }
                            if( funcName ==  "find" || funcName ==  "first" ||
                                funcName ==  "findJoin" || funcName ==  "firstJoin" ||
                                funcName ==  "findMany" || funcName ==  "firstMany" ||
                                funcName == "read" ) {
                                return baseMap.get( funcName )( where,params,sort ) ;
                            }
                            return baseMap.get( funcName )( where,params ) ;
                        } ;
                    }
                    else if( funcName == "limit" || funcName == "limitjoin" ) {
                        missing = function(offset,limit,params,sort) {
                            if( isNull( offset ) ) {
                                offset = 0 ;
                            }
                            if( isNull( limit ) ) {
                                limit = -1 ;
                            }
                            if( isNull( params ) ) {
                                params = null ;
                            }
                            var where = "" ;
                            var len = pms.length ;
                            for( var i = 2 ; i < len ; i ++ ) {
                                var columnName = org.maachang.dao.dbms.DbUtil.convertJavaNameByDBName( pms[ i ] ) ;
                                pms[ i ] = pms[ i ].toLowerCase() ;
                                if( ( i & 0x00000001 ) == 0 ) {
                                    //if( pms[ i ] == "and" || pms[ i ] == "or" ) {
                                    if( pms[ i ] == "and" ) {
                                        return false ;
                                    }
                                    where += " $"+columnName+"=?" ;
                                }
                                else {
                                    //if( pms[ i ] == "and" || pms[ i ] == "or" ) {
                                    if( pms[ i ] == "and" ) {
                                        where += " " + pms[ i ] ;
                                    }
                                    else {
                                        return false ;
                                    }
                                }
                            }
                            if( funcName == "limitjoin" ) {
                                funcName = "limitJoin" ;
                            }
                            return baseMap.get( funcName )( offset,limit,where,params,sort ) ;
                        } ;
                    }
                }
            }
            return missing ;
        },
        __has__ : function (name) {
            if( isNull( name ) ) {
                return null ;
            }
            return baseMap.containsKey(name);
        },
        __put__ : function (name, value) {
            if( isNull( name ) || isNull( value ) ) {
                return ;
            }
            if( value != null ) {
                baseMap.put( name,parseValue( value ) ) ;
            } ;
        },
        __delete__ : function (name) {
            if( isNull( name ) ) {
                return ;
            }
            baseMap.remove( name ) ;
        },
        __getIds__ : function () {
            return null ;
        }
    }) ;
} ;

