// 基本Exceptionスクリプト.
//

// 基本例外.
var Exception = function(message) {
    this.name = "Exception" ;
    if( useString( message ) ) {
        this.message = message ;
    }
    else {
        this.message = "" ;
    }
} ;
Exception.prototype = new Error;
Exception.prototype.toString = function() {
    if( useString( this.message ) ) {
        return "["+this.name+"] :message "+this.message ;
    }
    return "["+this.name+"]"
} ;


// NullPointerException.
var NullPointerException = function(message){
    if( useString( message ) ) {
        this.message = message;
    }
    else {
        this.message = "";
    }
};
NullPointerException.prototype = new Exception;
NullPointerException.prototype.name = 'NullPointerException';


// IllegalArgumentException.
var IllegalArgumentException = function(message){
    if( useString( message ) ) {
        this.message = message;
    }
    else {
        this.message = "";
    }
};
IllegalArgumentException.prototype = new Exception;
IllegalArgumentException.prototype.name = 'IllegalArgumentException';


// IndexOutOfBoundsException.
var IndexOutOfBoundsException = function(message){
    if( useString( message ) ) {
        this.message = message;
    }
    else {
        this.message = "";
    }
};
IndexOutOfBoundsException.prototype = new Exception;
IndexOutOfBoundsException.prototype.name = 'IndexOutOfBoundsException';


// IOException.
var IOException = function(message){
    if( useString( message ) ) {
        this.message = message;
    }
    else {
        this.message = "";
    }
};
IOException.prototype = new Exception;
IOException.prototype.name = 'IOException';


