package org.maachang.comet.httpd.engine.script.service.client;

/**
 * HTTPサービス.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public class HttpService {
    
    /**
     * 指定URLに対してPOSTでアクセス.
     * <BR><BR>
     * 指定URLに対してPOSTでアクセスします.
     * <BR>
     * @param url 対象のURLを設定します.
     * @param param 対象のパラメータを設定します.
     * @param header 対象のヘッダを設定します.
     * @param userAgent 対象のユーザエージェントを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public static final HttpResult post( String url,HttpParam param,HttpHeader header,String userAgent )
        throws Exception {
        return HttpClientAccess.connection( true,url,null,header,param,userAgent ) ;
    }
    
    /**
     * 指定URLに対してGETでアクセス.
     * <BR><BR>
     * 指定URLに対してGETでアクセスします.
     * <BR>
     * @param url 対象のURLを設定します.
     * @param param 対象のパラメータを設定します.
     * @param header 対象のヘッダを設定します.
     * @param userAgent 対象のユーザエージェントを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public static final HttpResult get( String url,HttpParam param,HttpHeader header,String userAgent )
        throws Exception {
        return HttpClientAccess.connection( false,url,null,header,param,userAgent ) ;
    }
    
    /**
     * 指定URLに対してBodyに情報を設定してアクセス.
     * <BR><BR>
     * 指定URLに対してBodyに情報を設定してアクセスします.
     * <BR>
     * @param url 対象のURLを設定します.
     * @param body 対象のBodyを設定します.
     * @param param 対象のパラメータを設定します.
     * @param header 対象のヘッダを設定します.
     * @param contentType 対象のコンテンツタイプを設定します.
     * @param userAgent 対象のユーザエージェントを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public static final HttpResult body( String url,byte[] body,HttpParam param,HttpHeader header,String contentType,String userAgent )
        throws Exception {
        return HttpClientAccess.connectionByInputBody( url,null,body,contentType,header,param,userAgent ) ;
    }
}
