package org.maachang.comet.httpd.engine.session ;

import java.util.Date;

/**
 * １つのセッションを表わすインターフェイス.
 *
 * @version 2008/05/26
 * @author  masahito suzuki
 * @since   MaachangComet 1.19
 */
public interface HttpdSession {
    
    /**
     * セッションを保持する名前.
     */
    public static final String SESSION_NAME = "maachang-session" ;
    
    /**
     * セッション要素を設定.
     * <BR><BR>
     * セッション要素を設定します.
     * <BR>
     * @param key セッションキーを設定します.
     * @param value セッション要素を設定します.
     */
    public void setElement( String key,String value ) ;
    
    /**
     * セッション要素を削除.
     * <BR><BR>
     * セッション要素を削除します.
     * <BR>
     * @param key セッションキーを設定します.
     */
    public void removeElement( String key ) ;
    
    /**
     * セッション要素を取得.
     * <BR><BR>
     * セッション要素を取得します.
     * <BR>
     * @param key セッションキーを設定します.
     * @return String セッション要素が返されます.
     */
    public String getElement( String key ) ;
    
    /**
     * セッションIDを取得.
     * <BR><BR>
     * セッションIDを取得します.
     * <BR>
     * @return String セッションIDが返されます.
     */
    public String getSessionId() ;
    
    /**
     * 更新時間を取得.
     * <BR><BR>
     * 更新時間を取得します.
     * <BR>
     * @return Date 生成時間が返されます.
     */
    public Date getUpdateDate() ;
    
}

