package org.maachang.comet.net ;

import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.HttpdResponse;
import org.maachang.comet.net.nio.ConnectionInfo;

/**
 * 受信コールバックインターフェイス.
 * 
 * @version 2008/05/28
 * @author  masahito suzuki
 * @since   MaachangComet 1.1B
 */
public interface HttpReceiveCallback {
    
    /**
     * 実行処理.
     * <BR><BR>
     * 受信実行処理を行います.
     * <BR>
     * @param conn コネクションオブジェクトを設定します.
     * @param seqId シーケンスIDを設定します.
     * @param request 対象のリクエスト情報を設定します.
     * @param response 対象のレスポンス情報を設定します.
     * @exception Exception 例外.
     */
    public void execution( ConnectionInfo conn,int seqId,HttpdRequest request,HttpdResponse response )
        throws Exception ;
}

