package org.maachang.comet.net ;

import java.nio.channels.ServerSocketChannel;

/**
 * サーバソケットインターフェイス.
 * 
 * @version 2007/11/17
 * @author  masahito suzuki
 * @since   MaachangComet 1.00
 */
public interface HttpServer {
    
    /**
     * オブジェクト破棄.
     */
    public void destroy() ;
    
    /**
     * サーバオブジェクトを取得.
     * <BR>
     * @return ServerSocketChannel サーバオブジェクトが返されます.
     */
    public ServerSocketChannel channel() ;
    
    /**
     * オプション情報を取得.
     * <BR>
     * @return Object オプション情報が返されます.
     */
    public Object option() ;
    
    /**
     * クローズチェック.
     * <BR>
     * @return [true]の場合、クローズしています.
     */
    public boolean isClosed() ;
    
}
