package org.maachang.dao ;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;

import org.maachang.dao.dbms.MetaColumn;
import org.maachang.dao.dbms.MetaFactory;

/**
 * １行読み込みDaoデータ.
 *
 * @version 2008/10/10
 * @author  masahito suzuki
 * @since MaachangDao 1.10
 */
public class ResultLine {
    
    /**
     * ResultSet.
     */
    protected ResultSet result = null ;
    
    /**
     * テーブル名.
     */
    protected String name = null ;
    
    /**
     * 位置.
     */
    protected int count = -1 ;
    
    /**
     * メタカラム.
     */
    protected MetaColumn column = null ;
    
    /**
     * コンストラクタ.
     */
    public ResultLine() {}
    
    /**
     * デストラクタ.
     */
    protected void finalize() throws Exception {
        this.clear() ;
    }
    
    /**
     * 情報生成.
     * @param name モデル名を設定します.
     * @param result 対象のResultSetを設定します.
     * @param column メタカラムオブジェクトを設定します.
     * @exception Exception 例外.
     */
    public void create( String name,ResultSet result,MetaColumn column )
        throws Exception {
        if( name == null || ( name = name.trim() ).length() <= 0 ||
            result == null ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        this.clear() ;
        this.result = result ;
        this.name = name ;
        this.column = column ;
    }
    
    /**
     * オブジェクトを破棄.
     */
    public void clear() {
        if( result != null ) {
            try {
                result.close() ;
            } catch( Exception e ) {
            }
        }
        result = null ;
        name = null ;
        column = null ;
        count = -1 ;
    }
    
    /**
     * １行情報を取得.
     * @return Map<String,Object> １行情報が返されます.
     * @exception Exception 例外.
     */
    public Map<String,Object> next() throws Exception {
        if( result == null ) {
            return null ;
        }
        if( result.next() == false ) {
            return null ;
        }
        if( column == null ) {
        	column = MetaFactory.getInstance().getMetaColumn( true,name ) ;
            //column = new MetaColumn(name,result.getMetaData());
        }
        Map<String,Object> ret = new HashMap<String,Object>() ;
        ExecutionDao.convertResultByObject( ret,column,result,column.size() ) ;
        count ++ ;
        return ret ;
    }
    
    /**
     * 現在位置を取得.
     * @return int 現在位置が返されます.
     */
    public int count() {
        return count ;
    }
    
    /**
     * モデル名を取得.
     * @return String モデル名が返されます.
     */
    public String getModelName() {
        return name ;
    }
    
    /**
     * オブジェクトが有効かチェック.
     * @return boolean [true]の場合、有効です.
     */
    public boolean isUse() {
        return ( result != null ) ;
    }
}

