package org.maachang.dao.dbms;

import java.sql.Connection;
import java.sql.ResultSet;

import org.maachang.dao.dbms.kind.SupportKind;

/**
 * DBアクセスオブジェクト.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaachangDao 1.00
 */
public interface Record {
    /**
     * クローズ処理. <BR>
     * <BR>
     * オブジェクトをクローズします.
     */
    public void close() ;

    /**
     * コネクションオブジェクトを取得. <BR>
     * <BR>
     * コネクションオブジェクトを取得します. <BR>
     * 
     * @return Connection コネクションオブジェクトが返されます.
     */
    public Connection getConnection() ;

    /**
     * コミット処理. <BR>
     * <BR>
     * コミット処理を実施します. <BR>
     * 
     * @return boolean [true]の場合、コミット処理が呼ばれました.
     * @exception Exception 例外.
     */
    public boolean commit() throws Exception ;

    /**
     * ロールバック処理. <BR>
     * <BR>
     * ロールバック処理を実施します. <BR>
     * 
     * @return boolean [true]の場合、ロールバック処理が呼ばれました.
     * @exception Exception 例外.
     */
    public boolean rollback() throws Exception ;

    /**
     * 管理ステートメントをクリア.
     * <BR><BR>
     * 管理しているステートメントをクリアします.
     */
    public void clearStatements() ;

    /**
     * メタカラムを取得. <BR>
     * <BR>
     * メタカラムを取得します. <BR>
     * 
     * @param table
     *            対象のテーブル名を設定します.
     * @return MetaColumn メタカラムが返されます.
     * @exception Exception
     *                例外.
     */
    public MetaColumn getMetaColumn(String table) throws Exception ;

    /**
     * このオブジェクトが利用可能かチェック. <BR>
     * <BR>
     * このオブジェクトが利用可能かチェックします. <BR>
     * 
     * @return boolean [true]の場合、利用可能です.
     */
    public boolean isUse() ;

    /**
     * データ取得用ステートメントを実行. <BR>
     * <BR>
     * データ取得用のステートメントを実行します. <BR>
     * 
     * @param sql
     *            対象のSQLを設定します.
     * @return ResultSet 対象の結果情報が返されます.
     * @exception Exception
     *                例外.
     */
    public ResultSet executeQuery(String sql) throws Exception ;

    /**
     * データ取得用ステートメントを実行. <BR>
     * <BR>
     * データ取得用のステートメントを実行します. <BR>
     * 
     * @param sql
     *            対象のSQLを設定します.
     * @return int 対象の結果情報が返されます.
     * @exception Exception
     *                例外.
     */
    public int executeUpdate(String sql) throws Exception ;

    /**
     * データ取得用ステートメントを実行. <BR>
     * <BR>
     * データ取得用のステートメントを実行します. <BR>
     * 
     * @param sql
     *            対象のパースされたSQLを設定します.
     * @param meta
     *            対象のメタデータを設定します.
     * @param params
     *            対象のパラメータを設定します.
     * @param size
     *            対象のパラメータ長を設定します.
     * @return ResultSet 対象の結果情報が返されます.
     * @exception Exception
     *                例外.
     */
    public ResultSet executeQuery(String sql, Object[] params,int size)
        throws Exception ;

    /**
     * データ取得用ステートメントを実行. <BR>
     * <BR>
     * データ取得用のステートメントを実行します. <BR>
     * 
     * @param sql
     *            対象のパースされたSQLを設定します.
     * @param meta
     *            対象のメタデータを設定します.
     * @param params
     *            対象のパラメータを設定します.
     * @param size
     *            対象のパラメータ長を設定します.
     * @return int 対象の結果情報が返されます.
     * @exception Exception
     *                例外.
     */
    public int executeUpdate(String sql, Object[] params,int size)
        throws Exception ;

    /**
     * サポートDBMS種類オブジェクトを取得.
     * <BR><BR>
     * サポートDBMS種類オブジェクトを取得します.
     * <BR>
     * @return SupportKind サポートDBMS種類が返されます.
     */
    public SupportKind getSupportKind() ;

    /**
     * シーケンス取得条件を取得.
     * <BR><BR>
     * シーケンス取得条件を取得します.
     * <BR>
     * @return boolean [true]の場合は、前に取得できます.
     */
    public boolean isSequence() ;

    /**
     * デバッグモードを取得.
     * <BR>
     * @return [true]の場合、デバッグは有効です.
     */
    public boolean isDebug() ;

}
