package org.maachang.dao.dbms.kind;

import org.maachang.dao.dbms.DbUtil;

/**
 * HSQL用DBMSサポート定義.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaachangDao 1.00
 */
public class KindByHSql extends SupportKind {
    
    /**
     * Boolean非サポートフラグ.
     * <BR><BR>
     * Boolean非サポートフラグを取得します.
     * <BR>
     * @return boolean [true]の場合は、サポートしています.
     */
    public boolean isBoolean() {
        return true ;
    }
    
    /**
     * アダプタ名を取得.
     * <BR><BR>
     * アダプタ名を取得します.
     * <BR>
     * @return String アダプタ名が返されます.
     */
    public String getAdapter() {
        return "hsqldb" ;
    }
    
    /**
     * IDを設定した後の取得SQL.
     * <BR><BR>
     * IDを設定した後の取得SQLが返されます.
     * <BR>
     * @return String SQLが返されます.
     */
    public String getInsertIdBySQL() {
        return "CALL IDENTITY()";
    }
    
    /**
     * 新しいIDの取得SQL.
     * <BR><BR>
     * 指定モデルに対する新しいIDを取得するSQLが返されます.
     * <BR>
     * @param model 対象のモデル名を設定します.
     * @return String SQLが返されます.
     */
    public String getSequenceId( String model ) {
        return new StringBuilder().append( "SELECT NEXT VALUE FOR " ).
            append( DbUtil.convertJavaNameByDBName( model ) ).
            append( SEQ_NAME ).
            append( " FROM INFORMATION_SCHEMA.SYSTEM_TABLES WHERE table_name = 'SYSTEM_TABLES'" ).toString() ;
    }
    
}
