package org.maachang.session.client ;

/**
 * クライアント永続化セッション.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
public interface PSession {
    
    /**
     * 指定要素を追加.
     * @param key 対象のKey名を設定します.
     * @param value 対象の要素を設定します.
     * @exception Exception 例外.
     */
    public void put( String key,Object value ) throws Exception ;
    
    /**
     * 指定要素を削除.
     * @param key 対象のKey名を設定します.
     * @exception Exception 例外.
     */
    public void remove( String key ) throws Exception ;
    
    /**
     * 指定要素を取得.
     * @param key 対象のKey名を設定します.
     * @return Object 対象の要素が返されます.
     * @exception Exception 例外.
     */
    public Object get( String key ) throws Exception ;
    
    /**
     * セッションIDを取得.
     * @return String セッションIDが返されます.
     * @exception Exception 例外.
     */
    public String getSessionId() throws Exception ;
    
    /**
     * 現在のセッション更新時間を取得.
     * @return long セッション更新時間が返されます.
     * @exception Exception 例外.
     */
    public long getUpdateTime() throws Exception ;
    
}

