package org.maachang.session.client ;

import org.maachang.util.BaseRandom;

/**
 * クライアント永続化セッション管理.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
public interface PSessionManager {
    
    /**
     * 新しいセッションIDを取得.
     * @param baseRandom ランダムオブジェクトを設定します.
     * @return String 新しいセッションIDが返されます.
     * @exception Exception 例外.
     */
    public String createSession( BaseRandom baseRandom ) throws Exception ;
    
    /**
     * 指定セッションIDのセッションオブジェクトを取得.
     * @param baseRandom ランダムオブジェクトを設定します.
     * @return PSession セッションオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public PSession getSession( BaseRandom baseRandom ) throws Exception ;
    
    /**
     * 指定セッションIDのセッションオブジェクトを取得.
     * @param baseRandom ランダムオブジェクトを設定します.
     * @param sessionId 対象のセッションIDを設定します.
     * @return PSession セッションオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public PSession getSession( BaseRandom baseRandom,String sessionId ) throws Exception ;
    
    /**
     * 指定セッションIDを削除.
     * @param sessionId 対象のセッションIDを設定します.
     * @exception Exception 例外.
     */
    public void reomveSession( String sessionId ) throws Exception ;
    
    /**
     * 指定セッションIDが存在するかチェック.
     * @param sessionId 対象のセッションIDを設定します.
     * @return boolean [true]の場合、セッション情報は存在します.
     * @exception Exception 例外.
     */
    public boolean isSession( String sessionId ) throws Exception ;
    
    /**
     * セッション削除時間を取得.
     * @return long セッション削除時間が返されます.
     * @exception Exception 例外.
     */
    public long getDeleteSessionTime() throws Exception ;
}

