package org.maachang.session.engine ;

import org.maachang.dbm.MDbmOp;
import org.maachang.util.BaseRandom;

/**
 * 永続化セッション管理インターフェイス.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
public interface PersistenceEngine {
    
    /**
     * セッションIDサイズ.
     */
    public static final int SESSION_KEY_LENGTH = 48 ;
    
    /**
     * 新しいセッションキーを生成.
     * @param baseRandom ランダムオブジェクトを設定します.
     * @return String 新しいSessionKeyが返されます.
     * @exception Exception 例外.
     */
    public String createSessionId( BaseRandom baseRandom )
        throws Exception ;
    
    /**
     * セッションに１つの要素を設定.
     * @param sessionId 対象のセッションIDを設定します.
     * @param key 対象のKeyを設定します.
     * @param value 対象の要素を設定します.
     * @exception Exception 例外.
     */
    public void put( String sessionId,String key,byte[] value )
        throws Exception ;
    
    /**
     * セッションを削除.
     * @param sessionId 対象のセッションIDを設定します.
     * @exception Exception 例外.
     */
    public void remove( String sessionId ) throws Exception ;
    
    /**
     * セッションから１つの要素を削除.
     * @param sessionId 対象のセッションIDを設定します.
     * @param key 対象のKeyを設定します.
     * @exception Exception 例外.
     */
    public void remove( String sessionId,String key )
        throws Exception ;
    
    /**
     * セッションから１つの要素を取得.
     * @param sessionId 対象のセッションIDを設定します.
     * @param key 対象のKeyを設定します.
     * @return byte[] １つの要素が返されます.
     * @exception Exception 例外.
     */
    public byte[] get( String sessionId,String key )
        throws Exception ;
    
    /**
     * 指定セッション更新時間を取得.
     * @param sessionId 対象のセッションIDを設定します.
     * @return long 対象の更新時間が返されます.
     * @exception Exception 例外.
     */
    public long getLastUpdateTime( String sessionId ) throws Exception ;
    
    /**
     * 指定セッション情報が存在するかチェック.
     * @param sessionId 対象のセッションIDを設定します.
     * @return boolean [true]の場合、セッションIDは存在します.
     */
    public boolean containsKey( String sessionId ) ;
    
    /**
     * MDBMオブジェクトを取得.
     * @return MDbmOp MDBMオブジェクトが返されます.
     */
    public MDbmOp getMDbm() ;
    
    /**
     * セッション削除時間を取得.
     * @return long セッション削除時間が返されます.
     */
    public long getDeleteSessionTime() ;
    
    /**
     * このオブジェクトが有効かチェック.
     * @return boolean [true]が返された場合、オブジェクトは有効です.
     */
    public boolean isUse() ;
}

