package org.maachang.jsr.script.api;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.script.Bindings;

public class ExternalBindings implements Bindings {
    private static final ExternalBindings SNGL = new ExternalBindings() ;
    private ExternalBindings() {
    }
    public static final ExternalBindings getInstance() {
        //return new ExternalBindings() ;
        return SNGL ;
    }
    
    public Object put(String name, Object value) {
        return ApiManager.getLocal().put( name,value ) ;
    }
    
    public void putAll(Map<? extends String, ? extends Object> toMerge) {
        if (toMerge == null) {
            throw new NullPointerException("toMerge map is null");
        }
        for (Map.Entry<? extends String, ? extends Object> entry : toMerge.entrySet()) { 
            String key = entry.getKey();
            put(key, entry.getValue());
        }
    }
    
    public void clear() {
        ApiManager.removeLocal() ;
    }
    
    public Map<String,Object> getLocal() {
        return ApiManager.getLocal() ;
    }
    
    public boolean containsKey(Object key) {
        checkKey(key) ;
        boolean ret = ApiManager.getLocal().containsKey( key ) ;
        if( ret == false ) {
            ret = ApiManager.getInstance().containsKey( key ) ;
        }
        return ret ;
    }
    
    public boolean containsValue(Object value) {
        return false ;
    }
    
    public Set<Map.Entry<String, Object>> entrySet() {
        return null ;
    }
    
    public Object get(Object key) {
        checkKey(key);
        Object ret = ApiManager.getLocal().get( key ) ;
        if( ret == null ) {
            ret = ApiManager.getInstance().get( key ) ;
        }
        return ret ;
    }
    
    public boolean isEmpty() {
        boolean ret = ( ApiManager.getLocal().size() <= 0 ) ;
        if( ret == true ) {
            ret = ( ApiManager.getInstance().size() <= 0 ) ;
        }
        return ret ;
    }
    
    public Set<String> keySet() {
        Set<String> ret = new HashSet<String>() ;
        ApiManager.getInstance().getAllKey( ret ) ;
        Set s = ApiManager.getLocal().keySet() ;
        if( s != null ) {
            Iterator ita = s.iterator() ;
            while( ita.hasNext() ) {
                ret.add( ( String )ita.next() ) ;
            }
        }
        return ret ;
    }
    
    public Object remove(Object key) {
        checkKey(key);
        return ApiManager.getLocal().remove(key);
    }
    
    public int size() {
        return ApiManager.getInstance().size() + ApiManager.getLocal().size() ;
    }
    
    public Collection<Object> values() {
        return null ;
    }
    
    private void checkKey(Object key) {
        if (key == null) {
            throw new NullPointerException("指定Keyは存在しません");
        }
        if (!(key instanceof String)) {
            throw new ClassCastException("指定キーは文字列ではありません");
        }
        if (key.equals( "" )) {
            throw new IllegalArgumentException("指定キーに文字列は存在しません");
        }
    }
}
