/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jni.unsafe;

import org.maachang.jni.unsafe.Native;
import org.maachang.jni.unsafe.Unsafe;

public final class DirectMemoryIO {
    private static final boolean UnsafeMode = Unsafe.UNSAFE_MODE;
    private static final sun.misc.Unsafe unsafe = Unsafe.unsafe;

    private DirectMemoryIO() {
    }

    public static final long malloc(int size) {
        return Native.malloc(size);
    }

    public static final long realloc(long address, int size) {
        return Native.realloc(address, size);
    }

    public static final void free(long address) {
        Native.free(address);
    }

    public static final void memset(long address, byte code, int size) {
        Native.memset(address, code, size);
    }

    public static final void memcpy(long destAddr, long srcAddr, int size) {
        Native.memcpy(destAddr, srcAddr, size);
    }

    public static final byte get(long address, int no) {
        if (UnsafeMode) {
            return unsafe.getByte(address + (long)no);
        }
        return Native.getByte(address, no);
    }

    public static final void put(long address, int no, byte value) {
        if (UnsafeMode) {
            unsafe.putByte(address + (long)no, value);
        } else {
            Native.putByte(address, no, value);
        }
    }
}

