/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jni.unsafe;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.maachang.jni.unsafe.IsOs;
import org.maachang.jni.unsafe._atomicBOOL;

class Native {
    private static final _atomicBOOL initFlag = new _atomicBOOL(false);

    static {
        String name = "unsafe";
        String lib = String.valueOf(name) + "-" + "1.0.0";
        switch (IsOs.getInstance().getOS()) {
            case 33: {
                lib = String.valueOf(lib) + ".dll";
                System.load(Native.targetDynamincLib(true, lib));
                initFlag.set(true);
                break;
            }
            case 1: {
                lib = String.valueOf(lib) + ".so";
                System.load(Native.targetDynamincLib(true, lib));
                initFlag.set(true);
                break;
            }
            default: {
                initFlag.set(false);
            }
        }
    }

    private static final String targetDynamincLib(boolean mode, String lib) {
        String sp = System.getProperty("file.separator");
        File targetDir = null;
        targetDir = new File(System.getProperty("user.home") + sp + ".lib_work");
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        File outFile = new File(targetDir, lib);
        if (mode) {
            BufferedInputStream is;
            String ntvDir = "org/maachang/jni/unsafe/native/";
            if (!(ntvDir = ntvDir.trim()).endsWith("/")) {
                ntvDir = String.valueOf(ntvDir) + "/";
            }
            if (ntvDir.startsWith("/")) {
                ntvDir = ntvDir.substring(1);
            }
            if (Native.isLibFile(outFile, is = new BufferedInputStream(Thread.currentThread().getContextClassLoader().getResourceAsStream(String.valueOf(ntvDir) + lib)))) {
                try {
                    BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outFile));
                    try {
                        try {
                            int n;
                            while ((n = ((InputStream)is).read()) > -1) {
                                ((OutputStream)os).write(n);
                            }
                            ((OutputStream)os).flush();
                        }
                        finally {
                            ((InputStream)is).close();
                            is = null;
                        }
                    }
                    finally {
                        ((OutputStream)os).close();
                        os = null;
                    }
                }
                catch (Exception e) {
                    outFile = null;
                }
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                is = null;
            }
        }
        if (outFile != null) {
            return outFile.getAbsolutePath();
        }
        return null;
    }

    private static final boolean isLibFile(File f, InputStream in) {
        boolean ret = false;
        try {
            int len;
            ret = !f.exists() ? true : (len = (int)f.length()) <= 0 || len != in.available();
        }
        catch (Exception e) {
            ret = true;
        }
        return ret;
    }

    protected static final boolean useInit() {
        return initFlag.get();
    }

    protected Native() {
    }

    protected static native long malloc(int var0);

    protected static native long realloc(long var0, int var2);

    protected static native void free(long var0);

    protected static native void memset(long var0, byte var2, int var3);

    protected static native void memcpy(long var0, long var2, int var4);

    protected static native byte getByte(long var0, int var2);

    protected static native void putByte(long var0, int var2, byte var3);
}

