/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jni.unsafe;

import java.nio.ByteBuffer;
import org.maachang.jni.unsafe.DirectMemoryIO;

public class UnsafeTest {
    private void test1() {
        int len = 100;
        long addr = DirectMemoryIO.malloc(len);
        int i = 0;
        while (i < len) {
            DirectMemoryIO.put(addr, i, (byte)(i + 1));
            ++i;
        }
        i = 0;
        while (i < len) {
            System.out.println("[" + i + "]=" + DirectMemoryIO.get(addr, i));
            ++i;
        }
        DirectMemoryIO.free(addr);
    }

    private void bench() {
        int benchLen = 1000000;
        int len = 100;
        int loop = 0;
        while (loop < 5) {
            ByteBuffer buf = ByteBuffer.allocateDirect(len);
            long t = System.currentTimeMillis();
            int j = 0;
            while (j < benchLen) {
                int i = 0;
                while (i < len) {
                    buf.put(i, (byte)i);
                    ++i;
                }
                ++j;
            }
            t = System.currentTimeMillis() - t;
            System.out.println("##ByteBuffer(Direct):time:" + t + "msec");
            byte[] b = new byte[len];
            t = System.currentTimeMillis();
            int j2 = 0;
            while (j2 < benchLen) {
                int i = 0;
                while (i < len) {
                    b[i] = (byte)i;
                    ++i;
                }
                ++j2;
            }
            t = System.currentTimeMillis() - t;
            System.out.println("##JavaMemory:time:" + t + "msec");
            b = null;
            long addr = DirectMemoryIO.malloc(len);
            t = System.currentTimeMillis();
            int j3 = 0;
            while (j3 < benchLen) {
                int i = 0;
                while (i < len) {
                    DirectMemoryIO.put(addr, i, (byte)i);
                    ++i;
                }
                ++j3;
            }
            t = System.currentTimeMillis() - t;
            System.out.println("**UnsafeTest**:time:" + t + "msec");
            DirectMemoryIO.free(addr);
            ++loop;
        }
    }

    public static final void main(String[] args) throws Exception {
        UnsafeTest t = new UnsafeTest();
        if (args.length > 0 && "test".equals(args[0])) {
            t.test1();
        } else {
            t.bench();
        }
    }
}

