#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../../include/org_maachang_jni_unsafe_Native.h"

/** malloc. **/
JNIEXPORT jlong JNICALL Java_org_maachang_jni_unsafe_Native_malloc
  (JNIEnv* env, jclass c, jint size) {
    return (jlong)malloc( size ) ;
}

/** realloc. **/
JNIEXPORT jlong JNICALL Java_org_maachang_jni_unsafe_Native_realloc
  (JNIEnv* env, jclass c, jlong addr, jint size) {
    return (jlong)realloc( (void*)addr,size ) ;
}

/** free. **/
JNIEXPORT void JNICALL Java_org_maachang_jni_unsafe_Native_free
  (JNIEnv* env, jclass c, jlong addr) {
    free( (void*)addr ) ;
}

/** memset. **/
JNIEXPORT void JNICALL Java_org_maachang_jni_unsafe_Native_memset
  (JNIEnv* env, jclass c, jlong addr, jbyte code, jint size ) {
    memset( (void*)addr,code,size ) ;
}

/** memcpy. **/
JNIEXPORT void JNICALL Java_org_maachang_jni_unsafe_Native_memcpy
  (JNIEnv* env, jclass c, jlong srcAddr, jlong destAddr, jint size ) {
    memcpy( (void*)srcAddr,(void*)destAddr,size ) ;
}

/** getByte. **/
JNIEXPORT jbyte JNICALL Java_org_maachang_jni_unsafe_Native_getByte
  (JNIEnv* env, jclass c, jlong addr, jint no ) {
    return *(((char*)addr)+no) ;
}

/** putByte. **/
JNIEXPORT void JNICALL Java_org_maachang_jni_unsafe_Native_putByte
  (JNIEnv* env, jclass c, jlong addr, jint no, jbyte value ) {
    *(((char*)addr)+no) = value ;
}

