package org.maachang.jni.unsafe;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Native呼び出し処理.
 * 
 * @version 2010/06/03
 * @author  masahito suzuki
 * @since   Unsafe-1.0.0
 */
class Native {
    private static final _atomicBOOL initFlag = new _atomicBOOL( false ) ;
    static {
        String name = NativeDefine.LIB_NAME ;
        String lib = name + "-" + NativeDefine.VERSION ;
        switch( IsOs.getInstance().getOS() ) {
            case IsOs.OS_WINNT :
                lib += NativeDefine.WINDOWS_LIB_PLUS ;
                System.load( targetDynamincLib( true,lib ) ) ;
                initFlag.set( true ) ;
                break ;
            case IsOs.OS_UNIX :
                lib += NativeDefine.LINUX_LIB_PLUS ;
                System.load( targetDynamincLib( true,lib ) ) ;
                initFlag.set( true ) ;
                break ;
            default :
                initFlag.set( false ) ;
                break ;
        }
    }
    
    private static final String targetDynamincLib( boolean mode,String lib ) {
        String sp = System.getProperty( "file.separator" ) ;
        File targetDir = null ;
        targetDir = new File( new StringBuilder().
            append( System.getProperty( "user.home" ) ).
            append( sp ).
            append( NativeDefine.DEFAULT_DIR ).
            toString() );
        if( targetDir.exists() == false ) {
            targetDir.mkdirs() ;
        }
        File outFile = new File( targetDir,lib );
        if( mode == true ) {
            String ntvDir = NativeDefine.NATIVE_PACKAGE ;
            ntvDir = ntvDir.trim() ;
            if( ntvDir.endsWith( "/" ) == false ) {
                ntvDir += "/" ;
            }
            if( ntvDir.startsWith( "/" ) ) {
                ntvDir = ntvDir.substring( 1 ) ;
            }
            InputStream is = new BufferedInputStream(
                Thread.currentThread().getContextClassLoader().getResourceAsStream(
                    ntvDir + lib ) ) ;
            if( isLibFile( outFile,is ) ) {
                try{
                    OutputStream os = new BufferedOutputStream( new FileOutputStream( outFile ) ) ;
                    try{
                        try{
                            while( true ) {
                                int n = is.read();
                                if( n <= -1 ) {
                                    break;
                                }
                                os.write( n );
                            }
                            os.flush() ;
                        }
                        finally{
                            is.close();
                            is = null ;
                        }
                    }
                    finally{
                        os.close();
                        os = null ;
                    }
                }
                catch( Exception e ) {
                    outFile = null ;
                }
            }
            if( is != null ) {
                try {
                    is.close() ;
                } catch( Exception e ) {
                }
                is = null ;
            }
        }
        if( outFile != null ) {
            return outFile.getAbsolutePath() ;
        }
        return null ;
    }
    
    private static final boolean isLibFile( File f,InputStream in ) {
        boolean ret = false ;
        try {
            if( f.exists() == false ) {
                ret = true ;
            }
            else {
                int len = ( int )f.length() ;
                ret = ( len <= 0 || len != in.available() ) ;
            }
        } catch( Exception e ) {
            ret = true ;
        }
        return ret ;
    }
    
    protected static final boolean useInit() {
        return initFlag.get() ;
    }
    
    protected Native() {
        
    }
    
    /** memory-i/o. **/
    protected static native long malloc( int size ) ;
    protected static native long realloc( long address,int size ) ;
    protected static native void free( long address ) ;
    protected static native void memset( long address,byte code,int size ) ;
    protected static native void memcpy( long destAddr,long srcAddr,int size ) ;
    protected static native byte getByte( long address,int no ) ;
    protected static native void putByte( long address,int no,byte value ) ;
    
}

class _atomicBOOL {
    private final AtomicInteger ato = new AtomicInteger( 0 ) ;
    public _atomicBOOL() {
        
    }
    public _atomicBOOL( boolean f ) {
        setting( ( f ) ? 1 : 0 ) ;
    }
    public boolean get() {
        return ato.get() != 0 ;
    }
    
    public void set( boolean f ) {
        setting( ( f ) ? 1 : 0 ) ;
    }
    
    private void setting( int no ) {
        while( !ato.compareAndSet( ato.get(),no ) ) {}
    }
}
