package org.maachang.jni.unsafe ;

import java.lang.reflect.Field;

/**
 * sun.misc.Unsafeを呼び出し.
 * 
 * @version 2010/06/03
 * @author  masahito suzuki
 * @since   Unsafe-1.0.0
 */
public final class Unsafe {
    private static final String UNSAFE_FIELD = "theUnsafe" ;
    public static final boolean UNSAFE_MODE ;
    public static final sun.misc.Unsafe unsafe ;
    
    static {
        sun.misc.Unsafe u = null ;
        try {
            Field f = sun.misc.Unsafe.class.getDeclaredField( UNSAFE_FIELD ) ;
            f.setAccessible(true) ;
            u = (sun.misc.Unsafe) f.get(null) ;
        } catch (Exception e) {
            System.err.println("sun.misc.Unsafeの呼び出しに失敗しました.");
        } finally {
            unsafe = u ;
            UNSAFE_MODE = ( u != null ) ;
        }
    }
    
    /**
     * sun.misc.Unsafeオブジェクトを取得.
     * @return sun.misc.Unsafe オブジェクトが返されます.
     */
    public static sun.misc.Unsafe get() {
        return unsafe;
    }
}

