package org.maachang.jni.unsafe;

import java.nio.ByteBuffer;

/**
 * Unsafeテスト or ベンチマーク.
 * 
 * @version 2010/06/03
 * @author  masahito suzuki
 * @since   Unsafe-1.0.0
 */
public class UnsafeTest {
    
    private void test1() {
        int len = 100 ;
        long addr = DirectMemoryIO.malloc( len ) ;
        for( int i = 0 ; i < len ; i ++ ) {
            DirectMemoryIO.put( addr,i,(byte)(i+1) ) ;
        }
        for( int i = 0 ; i < len ; i ++ ) {
            System.out.println( "[" + i + "]=" + DirectMemoryIO.get( addr,i ) ) ;
        }
        DirectMemoryIO.free( addr ) ;
    }
    
    private void bench() {
        int benchLen = 1000000 ;
        int len = 100 ;
        
        long t ;
        
        for( int loop = 0 ; loop < 5 ; loop ++ ) {
            
            // ByteBuffer(Direct)テスト. **
            ByteBuffer buf = ByteBuffer.allocateDirect( len ) ;
            t = System.currentTimeMillis() ;
            for( int j = 0 ; j < benchLen ; j ++ ) {
                for( int i = 0 ; i < len ; i ++ ) {
                    buf.put( i,(byte)i ) ;
                }
            }
            t = System.currentTimeMillis() - t ;
            System.out.println( "##ByteBuffer(Direct):time:" + t + "msec" ) ;
            
            //** JavaMemoryテスト. **
            byte[] b = new byte[ len ] ;
            t = System.currentTimeMillis() ;
            for( int j = 0 ; j < benchLen ; j ++ ) {
                for( int i = 0 ; i < len ; i ++ ) {
                    b[ i ] = (byte)i ;
                }
            }
            t = System.currentTimeMillis() - t ;
            System.out.println( "##JavaMemory:time:" + t + "msec" ) ;
            b = null ;
            
            // DirectMemoryテスト. **
            long addr = DirectMemoryIO.malloc( len ) ;
            t = System.currentTimeMillis() ;
            for( int j = 0 ; j < benchLen ; j ++ ) {
                for( int i = 0 ; i < len ; i ++ ) {
                    DirectMemoryIO.put( addr,i,(byte)i ) ;
                }
            }
            t = System.currentTimeMillis() - t ;
            System.out.println( "**UnsafeTest**:time:" + t + "msec" ) ;
            DirectMemoryIO.free( addr ) ;
        }
    }
    
    public static final void main( String[] args ) throws Exception {
    	UnsafeTest t = new UnsafeTest() ;
    	if( args.length > 0 && "test".equals( args[ 0 ] ) ) {
	        t.test1() ;
    	}
    	else {
	        t.bench() ;
    	}
    }
    
}
