/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.maachang.reflect.FastReflectPrimitive;
import org.maachang.reflect.FastReflectUtil;

class FastConstructorElements {
    private final List<FastConstructorEmt> list = new ArrayList<FastConstructorEmt>();

    private FastConstructorElements() {
    }

    public FastConstructorElements(Class clazz) {
        Constructor<?>[] cs = clazz.getDeclaredConstructors();
        if (cs != null) {
            for (Constructor<?> c : cs) {
                if (!Modifier.isPublic(c.getModifiers())) continue;
                this.list.add(new FastConstructorEmt(c));
            }
        }
    }

    protected void finalize() throws Exception {
        this.list.clear();
    }

    public Object newInstance(ClassLoader cl, Class[] types, Object[] args) throws ClassNotFoundException, InstantiationException, InvocationTargetException, IllegalAccessException {
        int argsLen;
        int len = this.list.size();
        int n = argsLen = args == null ? 0 : args.length;
        if (argsLen == 0) {
            for (int i = 0; i < len; ++i) {
                FastConstructorEmt emt = this.list.get(i);
                if (emt.paramsLength != 0) continue;
                return emt.constructor.newInstance(FastReflectPrimitive.NO_PARAM);
            }
        } else {
            int pf = 100 * argsLen;
            int score = -1;
            FastConstructorEmt targetEmt = null;
            for (int i = 0; i < len; ++i) {
                int sc;
                FastConstructorEmt emt = this.list.get(i);
                if (emt.paramsLength != argsLen || (sc = FastReflectUtil.parmasScore(emt.primitives, emt.params, types, args, cl)) == -1 || score >= sc) continue;
                if (sc == pf) {
                    return emt.constructor.newInstance(args);
                }
                score = sc;
                targetEmt = emt;
            }
            if (targetEmt != null) {
                if ((args = FastReflectUtil.convertParams(args, targetEmt.params)) == null) {
                    throw new IllegalAccessException("\u30d1\u30e9\u30e1\u30fc\u30bf\u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                }
                return targetEmt.constructor.newInstance(args);
            }
        }
        return null;
    }

    private static class FastConstructorEmt {
        protected Constructor constructor;
        protected Class[] params;
        protected boolean[] primitives;
        protected int paramsLength;

        protected FastConstructorEmt(Constructor constructor) {
            int len;
            boolean[] pms = null;
            Class<?>[] args = constructor.getParameterTypes();
            int n = len = args == null ? 0 : args.length;
            if (len == 0) {
                args = FastReflectPrimitive.NO_PARAM_CLASS;
            } else {
                pms = new boolean[len];
                for (int i = 0; i < len; ++i) {
                    pms[i] = args[i].isPrimitive();
                    Class pc = FastReflectPrimitive.CONV_PRIMITIVE.get(args[i]);
                    if (pc == null) continue;
                    args[i] = pc;
                }
            }
            constructor.setAccessible(true);
            this.constructor = constructor;
            this.params = args;
            this.primitives = pms;
            this.paramsLength = len;
        }
    }
}

