<?php
/*******************************************************************************
 *	JAPRO Template Engine
 *     Ver. 1.0
 *
 *	ex.
 *
 *	$template = new jte() ;
 *	$template->set_value( 'date', date( 'Y/m/d' ) ) ;
 *	$template->exexute( 'template/sample.html' ) ;
 *
 *	set_condition( str $name, bool $flag )
 *	set_value( str $name, str $value )
 *	set_record( str $name, array $record )
 *
 *		$record = array(
 *			array( 'condition' => $condition, 'value' => $value ),
 *			array( 'condition' => $condition, 'value' => $value )
 *		) ;
 *
 *	html
 *	<li jte="record: news">
 *		<a href="" jte="@href: href; text: title">新着情報</a>
 *	</li>
 *
 *******************************************************************************/

if ( mb_ereg( '^4\.', phpversion() ) ) {
	require( dirname( __FILE__ ) . '/jte_dom.php' ) ;
} else {
	if ( class_exists( 'DOMDocument' ) ) {
		class jte_DOMDocument extends DOMDocument {}
	} else {
		require( dirname( __FILE__ ) . '/jte_dom.php' ) ;
	}
}


class jte {
	var $version = '1.0' ;

	var $templateAttribute = 'jte' ;
	
	var $commands = array(
		'fake',
		'record',
		'condition',
		'text'
	) ;
	
	
	var $cache_use = false ;
	var $cache_dir = 'cache/' ;
	
	var $encoding = 'UTF-8' ;
	var $doctype = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">' ;
	var $xhtml ;
	var $dom ;
	
	var $set ;
	
	var $emptyTag = array(
		'meta',
		'base',
		'link',
		'basefont',
		'spacer',
		'br',
		'wbr',
		'hr',
		'img',
		'area',
		'param',
		'bgsound',
		'input'
	) ;
	
	var $blankAttribute = array(
		'checked',
		'compact',
		'declare',
		'defer',
		'disabled',
		'ismap',
		'multiple',
		'nohref',
		'noresize',
		'noshade',
		'nowrap',
		'selected',
		'target'
	) ;
	
	var $urlAttribute = array(
		'href',
		'src',
		'background',
		'cite',
		'action'
	) ;
	
	var $fakeCommands = array(
		'fake',
		'remove',
		'dummy'
	) ;
	
	var $log = true ;
	var $log_file = 'jte.log' ;
	
	
	//==================================================================
	// constructor
	
	function jte() {
		$this->__construct() ;
	}
	
	
	function __construct() {
		$this->set = array(
			'condition' => array(),
			'value' => array(),
			'record' => array()
		) ;
	}
	
	
	//==================================================================
	// set all
	
	function set( $hash ) {
		if ( isset( $hash[ 'function' ] ) ) {
			$this->set_functions( $hash[ 'function' ] ) ;
		}
		
		if ( isset( $hash[ 'condition' ] ) ) {
			$this->set_conditions( $hash[ 'condition' ] ) ;
		}
		
		if ( isset( $hash[ 'value' ] ) ) {
			$this->set_values( $hash[ 'value' ] ) ;
		}
		
		if ( isset( $hash[ 'record' ] ) ) {
			$this->set_records( $hash[ 'record' ] ) ;
		}
	}
	
	
	//==================================================================
	// set with hash
	
	function set_functions( $hash ) {
		foreach ( $hash as $name => $function ) {
			$this->set_function( $name, $function ) ;
		}
	}
	
	
	function set_conditions( $hash ) {
		foreach ( $hash as $name => $flag ) {
			$this->set_condition( $name, $flag ) ;
		}
	}
	
	
	function set_values( $hash ) {
		foreach ( $hash as $name => $value ) {
			$this->set_value( $name, $value ) ;
		}
	}
	
	
	function set_records( $hash ) {
		foreach ( $hash as $name => $record ) {
			$this->set_record( $name, $record ) ;
		}
	}
	
	
	//==================================================================
	// set
	
	function set_function( $name, $function ) {
		$this->set[ 'function' ][ $name ] = $function ;
	}
	
	
	function set_condition( $name, $flag ) {
		$this->set[ 'condition' ][ $name ] = ( $flag ) ? true : false ;
	}
	
	
	function set_value( $name, $value ) {
		$this->set[ 'value' ][ $name ] = $value ;
	}
	
	
	function set_record( $name, $record ) {
		$this->set[ 'record' ][ $name ] = $record ;
	}
	
	
	//==================================================================
	// load template
	
	function load( $path ) {
		if ( $this->cache_load( $path ) ) return true ;
		
		$html = @file_get_contents( $path ) ;
		
		if ( $html === false ) return false ;
		
		$html = $this->_delete_bom( $html ) ;
		
		$this->dom = new jte_DOMDocument( '1.0' ) ;
		$this->dom->encoding = $this->encoding ;
		$this->dom->validate = true ;
		
		$html = trim( $html ) ;
		
		if ( mb_ereg( '^(<\?xml\s(.|\n)*?\?>)\r?\n((.|\n)*)$', $html, $part ) ) {
			$html = $part[ 2 ] ;
		}
		
		if ( mb_ereg( '^(<\!DOCTYPE\s(.|\n)*?>)\r?\n((.|\n)*)$', $html, $part ) ) {
			$this->doctype = $part[ 1 ] ;
			$html = $part[ 3 ] ;
		}
		
		if ( ! mb_ereg( '^<html( (.|\n)*?)?>', $html ) ) {
			echo "No html !! " . htmlspecialchars( mb_substr( $html, 0, 20 ) ) . "...<br />\n" ;
			return false ;
		}
		
		$this->_parse( $this->dom, $html ) ;
		
		$this->cache_save( $path_cache ) ;
		
		return true ;
	}

	
	function cache_load( $path ) {
		if ( ! mb_ereg( '^4\.', phpversion() ) ) return false ;
		if ( ! $this->cache_use ) return false ;
		
		$path_cache = realpath( $this->cache_dir ) . '/' . urlencode( $path ) ; 
		
		if ( file_exists( $path_cache ) ) {
			if (  filemtime( $path ) < filemtime( $path_cache ) ) return false ;
		}
		
		$cache = @file_get_contents( $path_cache ) ;
		
		if ( $cache === false ) return false ;
		
		$this->dom = unserialize( $cache ) ;
		
		return true ;
	}

	
	function cache_save( $path ) {
		if ( ! mb_ereg( '^4\.', phpversion() ) ) return false ;
		if ( ! $this->cache_use ) return false ;
		
		$path_cache = realpath( $this->cache_dir ) . '/' . urlencode( $path ) ; 
		
		if ( file_exists( $path_cache ) ) {
			if (  filemtime( $path ) < filemtime( $path_cache ) ) return false ;
		}
		
		$cache = serialize( $this->dom ) ;
		
		@file_put_contents( $path_cache, $cache ) ;
		
		return ;
	}
	
	
	//==================================================================
	// replace template by set
	
	function replace() {
		$this->set[ 'root' ] = &$this->set ;
		
		$this->set[ 'parent' ] = array(
			'function' => array(),
			'condition' => array(),
			'value' => array(),
			'record' => array()
		) ;
		
		$dummy = null ;
		
		$this->_replace_element( $this->set, $this->dom->documentElement, $dummy ) ;
	}
	
	
	//==================================================================
	// output html
	
	function save() {
		$this->xhtml = mb_ereg( '\sXHTML\s', $this->doctype ) ;
		
		$html = "{$this->doctype}\n" ;
		
		$this->_tree( $html, $this->dom->documentElement ) ;
		
		return $html ;
	}
	
	
	//==================================================================
	// output html from template and set
	
	function execute( $path, $set ) {
		if ( $this->load( $path ) === false ) return false ;
		$this->set( $set ) ;
		$this->replace() ;
		echo $this->save() ;
	}
	
	
	//==================================================================
	// part of html
	
	function part_load( $html ) {
		$html = $this->_delete_bom( $html ) ;
		
		$this->dom = new jte_DOMDocument( '1.0' ) ;
		$this->dom->encoding = $this->encoding ;
		
		$part = "<part>" . trim( $html ) . "</part>" ;
		
		$this->_parse( $this->dom, $part ) ;
		
		return true ;
	}
	
	
	function part_save( $xhtml = true ) {
		$this->xhtml = $xhtml ;
		
		$html = "" ;
		
		for ( $n = 0 ; $n < $this->dom->documentElement->childNodes->length ; $n++ ) {
			$this->_tree( $html, $this->dom->documentElement->childNodes->item( $n ) ) ;
		}
		
		return $html ;
	}
	
	
	//==================================================================
	// common method
	
	
	function innerHTML( &$element, $html, $indent = false ) {
		if ( $element->nodeType != XML_ELEMENT_NODE ) return false ;
		
		$html = rtrim( $this->_delete_bom( $html ) ) ;
		
		// 改行または次のエレメントまでを保持
		
		$first = '' ;
		
		if ( $indent ) {
			while ( $element->childNodes->length > 0 ) {
				if ( $element->firstChild->nodeType == XML_TEXT_NODE ) {
					if ( mb_ereg( '^(\s*\n)((.|\n)*)$', $element->firstChild->nodeValue, $match ) ) {
						$first = "{$first}{$match[ 1 ]}" ;
						$element->firstChild->nodeValue = "\r\n{$match[ 2 ]}" ;
					}
					
					break ;
				}
				
				if ( $element->firstChild->nodeType != XML_COMMENT_NODE ) break ;
				
				$first = "{$first}<!--{$element->firstChild->nodeValue}-->" ;
				
				$element->removeChild( $element->firstChild ) ;
			}
		}
		
		// インデントを保持
		
		$last = '' ;
		
		if ( $indent ) {
			while ( $element->childNodes->length > 0 ) {
				if ( $element->lastChild->nodeType == XML_TEXT_NODE ) {
					if ( mb_ereg( '^((.|\n)*)(\r?\n\s*)$', $element->lastChild->nodeValue, $match ) ) {
						$last = "{$match[ 3 ]}{$last}" ;
						$element->lastChild->nodeValue = $match[ 1 ] ;
					}
					
					break ;
				}
				
				if ( $element->lastChild->nodeType != XML_COMMENT_NODE ) break ;
				
				$last = "<!--{$element->lastChild->nodeValue}-->{$last}" ;
				
				$element->removeChild( $element->lastChild ) ;
			}
		}
		
		// 空にする
		
		$childNodes =& $element->childNodes ;
		
		while ( $childNodes->length > 0 ) {
			$element->removeChild( $element->firstChild ) ;
		}
		
		$html = "{$first}{$html}{$last}" ;
		
		$this->_parse( $element, $html ) ;
		$this->_replace_childs( $this->set, $element ) ;
		
		return true ;
	}
	
	
	function outerHTML( &$element, $html ) {
		$html = rtrim( $this->_delete_bom( $html ) ) ;
		
		$div = $this->dom->createElement( 'div' ) ;
		
		$this->_parse( $div, $html ) ;
		$this->_replace_childs( $this->set, $div ) ;
		
		while ( $div->childNodes->length > 0 ) {
			$element->parentNode->insertBefore( $div->removeChild( $div->firstChild ), $element ) ;
		}
		
		$element->parentNode->removeChild( $element ) ;	
		
		return true ;
	}
	
	
	//==================================================================
	// Internal method
	
	function _delete_bom( $text ) {
		return mb_ereg_replace( '^\xef\xbb\xbf', '', $text ) ;
	}
	
	
	//==================================================================
	// _parse
	
	function _parse( &$parent, &$html, $open = '' ) {
		while ( $html != '' ) {
			if ( mb_ereg( '^<((.|\n)*)$', $html, $match ) ) {
				$html = $match[ 1 ] ;
				
				if ( $html == '' ) {
					$parent->appendChild( $this->dom->createTextNode( '<' ) ) ;
					continue ;
				}
				
				if ( mb_ereg( '^\!--((.|\n)*?)(-->((.|\n)*))$', $html, $match ) ) {
					$html = $match[ 4 ] ;
					$parent->appendChild( $this->dom->createComment( $match[ 1 ] ) ) ;
					continue ;
				}
				
				if ( mb_ereg( '^\!\[CDATA\[((.|\n)*?)(\]\]>((.|\n)*))$', $html, $match ) ) {
					$html = $match[ 4 ] ;
					$parent->appendChild( $this->dom->createCDATASection( $match[ 1 ] ) ) ;
					continue ;
				}
				
				if ( mb_ereg( '^\/(.*?)\s*(>((.|\n)*))$', $html, $match ) ) {
					$tagName = $match[ 1 ] ;
					
					if ( ( $open == '' ) or ( $open != $tagName ) ){
						echo "Not opened or invalid &lt;{$open}&gt; - &lt;/{$tagName}&gt;<br />\n" ;
						break ;
					}
					
					$html = $match[ 3 ] ;
					break ;
				}
				
				$this->_parse_element( $parent, $html ) ;
			} else {
				mb_ereg( '^([^<]+)((.|\n)*?)$', $html, $match ) ;
				$html = $match[ 2 ] ;
				if ( $this->log ) {
					$text = '' ;
					
					for ( $p = 0 ; $p < strlen( $match[ 1 ] ) ; $p++ ) {
						$text .= sprintf( '%02X', ord( substr( $match[ 1 ], $n, 1 ) ) ) ;
					}
				}
				$parent->appendChild( $this->dom->createTextNode( $match[ 1 ] ) ) ;
			}
		}
	}
	
	
	function _parse_element( &$parent, &$html ) {
		mb_ereg( '^("[^"]*"|\'[^\']*\'|(.|\n)*?)(>((.|\n)*))$', $html, $match ) ;
		$html = $match[ 4 ] ;
		$tag = $match[ 1 ] ;
		
		mb_ereg( '^(\S+)((.|\n)*?)( ?\/)?$', $tag, $match ) ;
		$tagName = strtolower( $match[ 1 ] ) ;
		$attributes = trim( $match[ 2 ] ) ;
		$closed = isset( $match[ 4 ] ) ? $match[ 4 ] : '' ;
		
		$node = $this->dom->createElement( $tagName ) ;
		$this->_parse_attributes( $node, $attributes ) ;
		
		if ( $closed == '' ) {
			if ( ! in_array( $tagName, $this->emptyTag ) ) {
				if ( $tagName == 'script' ) {
					if ( mb_eregi( '^((.|\n)*?)<\/script\s*>((.|\n)*)$', $html, $match ) ) {
						if ( $match[ 1 ] != '' ) {
							$node->appendChild( $this->dom->createTextNode( $match[ 1 ] ) ) ;
						}
						
						$html = $match[ 3 ] ;
					} else {
						if ( $html != '' ) {
							$node->appendChild( $this->dom->createTextNode( $html ) ) ;
						}
						
						$html = '' ;
					}
				} else {
					$this->_parse( $node, $html, $tagName ) ;
				}
			}
		}
		
		$parent->appendChild( $node ) ;
		
		return true ;
	}
	
	
	function _parse_attributes( &$node, &$attributes ) {
		while ( $attributes != '' ) {
			if ( mb_ereg( '^(\S+?)\s*=\s*("[^"]*"|\'[^\']*\'|\S)([^$]*)$', $attributes, $part ) ) {
				$attributes = trim( $part[ 3 ] ) ;
				
				$name = strtolower( $part[ 1 ] ) ;
				
				if ( mb_ereg( '^"([^"]*)"$', $part[ 2 ], $value ) ) {
					$node->setAttribute( $name, $value[ 1 ] ) ;
					continue ;
				}
				
				if ( mb_ereg( '^\'([^\']*)\'$', $part[ 2 ], $value ) ) {
					if ( in_array( $name, $this->urlAttribute ) ) {
						$node->setAttribute( $name, mb_ereg_replace( '"', '%22', $value[ 1 ] ) ) ;
					} else {
						$node->setAttribute( $name, mb_ereg_replace( '"', '&quot;', $value[ 1 ] ) ) ;
					}
					
					continue ;
				}
				
				$node->setAttribute( $part[ 1 ], $part[ 2 ] ) ;
				continue ;
			}
			
			mb_ereg( '^(\S*)([^$]*)$', $attributes, $part ) ;
			$attributes = trim( $part[ 2 ] ) ;
			
			if ( $part[ 1 ] != '' ) {
				$name = strtolower( $part[ 1 ] ) ;
				$node->setAttribute( $name, $name ) ;
			}
		}
	}
	
	
	//==================================================================
	// _replace
	
	function _replace_element( &$set, &$element, &$records ) {
		
		// replace ?
		
		if ( ! $element->hasAttribute( $this->templateAttribute ) ) {
			$this->_replace_childs( $set, $element ) ;
			return ;
		}
		
		$commands = $this->_replace_get_commands( $element->getAttribute( $this->templateAttribute ) ) ;
		
		if ( is_array( $records ) ) {
			
			// record -> _replace_child
			
			if ( isset( $commands[ 'record' ] ) ) {
				$name = $commands[ 'record' ] ;
				
				list( $local, $localName ) = $this->_replace_get_local( $set, $name ) ;
				$this->log_write( "_replace_element: {$element->tagName}: record: {$localName}" ) ;
				
				if ( isset( $local[ 'record' ][ $localName ] ) ) {
					if ( ! isset( $records[ $name ] ) ) $records[ $name ] = array() ;
					$records[ $name ][] =& $element ;
					$this->log_write( "_replace_element: {$element->tagName}: record" ) ;
					return ;
				}
			}
		}
		
		$element->removeAttribute( $this->templateAttribute ) ;
		
		// fake
		
		if ( isset( $commands[ 'fake' ] ) ) {
			$this->_replace_remove( $element ) ;
			$this->log_write( "_replace_element: {$element->tagName}: fake" ) ;
			return ;
		}
		
		// if/else
		
		if ( isset( $commands[ 'condition' ] ) ) {
			for ( $n = 0 ; $n < count( $commands[ 'condition' ] ) ; $n++ ) {
				$condition = $commands[ 'condition' ][ $n ][ 'condition' ] ;
				$name = $commands[ 'condition' ][ $n ][ 'name' ] ;
				
				list( $local, $localName ) = $this->_replace_get_local( $set, $name ) ;
				
				if ( isset( $local[ 'condition' ][ $localName ] ) ) {
					if ( $local[ 'condition' ][ $localName ] != $condition ) {
						$this->_replace_remove( $element ) ;
						$this->log_write( "_replace_element: {$element->tagName}: condition" ) ;
						return ;
					}
				}
				
				if ( isset( $local[ 'record' ][ $localName ] ) ) {
					$not_empty = ( count( $local[ 'record' ][ $localName ] ) > 0 ) ;
					
					if ( $not_empty != $condition ) {
						$this->_replace_remove( $element ) ;
						$this->log_write( "_replace_element: {$element->tagName}: condition" ) ;
						return ;
					}
				}
				
				if ( isset( $local[ 'value' ][ $localName ] ) ) {
					$not_empty = ( "{$local[ 'value' ][ $localName ]}" != '' ) ;
					
					if ( $not_empty != $condition ) {
						$this->_replace_remove( $element ) ;
						$this->log_write( "_replace_element: {$element->tagName}: condition" ) ;
						return ;
					}
				}
			}
		}
		
		if ( isset( $commands[ 'outer' ] ) ) {
			$this->log_write( "_replace_element: {$element->tagName}: outer" ) ;
			if ( $this->_replace_html( $set, $element, 'outer', $commands[ 'outer' ] ) ) return ;
		}
		
		if ( isset( $commands[ '@' ] ) ) {
			$this->log_write( "_replace_element: {$element->tagName}: @" ) ;
			for ( $n = 0 ; $n < count( $commands[ '@' ] ) ; $n++ ) {
				$attribute = $commands[ '@' ][ $n ][ 'attribute' ] ;
				$name = $commands[ '@' ][ $n ][ 'name' ] ;
				
				list( $local, $localName ) = $this->_replace_get_local( $set, $name ) ;
				
				if ( ! isset( $local[ 'value' ][ $localName ] ) ) continue ;
				
				if ( "{$local[ 'value' ][ $localName ]}" == '' ) {
					if ( in_array( $attribute, $this->blankAttribute ) ) {
						if ( $element->hasAttribute( $attribute ) ) {
							$element->removeAttribute( $attribute ) ;
						}
						
						continue ;
					}
				}
				
				$element->setAttribute( $attribute, $local[ 'value' ][ $localName ] ) ;
			}
		}
		
		if ( isset( $commands[ 'other' ] ) ) {
			for ( $n = 0 ; $n < count( $commands[ 'other' ] ) ; $n++ ) {
				$command = $commands[ 'other' ][ $n ][ 'command' ] ;
				$name = $commands[ 'other' ][ $n ][ 'name' ] ;
				
				switch ( $command ) {
					case 'function' :
						$this->log_write( "_replace_element: {$element->tagName}: function" ) ;
						list( $local, $localName ) = $this->_replace_get_local( $set, $name ) ;
						if ( ! isset( $local[ 'function' ][ $localName ] ) ) return false ;
						if ( ! is_callable( $local[ 'function' ][ $localName ] ) ) return false ;
						
						call_user_func_array( $local[ 'function' ][ $localName ], array( &$this, &$element, &$set, $command, $name ) ) ;
						
						break ;
					
					default :
						$this->log_write( "_replace_element: {$element->tagName}: {$command}" ) ;
						$method = "command_{$command}" ;
						
						if ( method_exists( $this, $method ) ) {
							$replace_child = call_user_func_array( array( $this, $method ), array( &$element, &$set, $command, $name ) ) ;
						}
				}
			}
		}
		
		if ( isset( $commands[ 'inner' ] ) ) {
			$this->log_write( "_replace_element: {$element->tagName}: inner" ) ;
			if ( $this->_replace_html( $set, $element, 'inner', $commands[ 'inner' ] ) ) return ;
		}
		
		if ( isset( $commands[ 'text' ] ) ) {
			$name = $commands[ 'text' ] ;
			
			list( $local, $localName ) = $this->_replace_get_local( $set, $name ) ;
			$this->log_write( "_replace_element: {$element->tagName}: text: {$localName}" ) ;
			
			if ( isset( $local[ 'value' ][ $localName ] ) ) {
				$br = ( $this->xhtml ) ? '<br />' : '<br>' ;
				
				$html = mb_ereg_replace( "\r?\n", "{$br}\n", htmlspecialchars( $local[ 'value' ][ $localName ] ) ) ;
					
				while ( $element->childNodes->length > 0 ) $element->removeChild( $element->firstChild ) ;
				
				$this->_parse( $element, $html ) ;
				$this->_replace_childs( $set, $element ) ;
				
				return ;
			}
		}
		
		if ( isset( $commands[ 'textarea' ] ) ) {
			$name = $commands[ 'textarea' ] ;
			
			$this->log_write( "_replace_element: {$element->tagName}: textarea" ) ;
			list( $local, $localName ) = $this->_replace_get_local( $set, $name ) ;
			
			if ( isset( $local[ 'value' ][ $localName ] ) ) {
				$html = htmlspecialchars( $local[ 'value' ][ $localName ] ) ;
			
				while ( $element->childNodes->length > 0 ) $element->removeChild( $element->firstChild ) ;
				
				$this->_parse( $element, $html ) ;
				$this->_replace_childs( $set, $element ) ;
				
				return ;
			}
		}
		
		$this->_replace_childs( $set, $element ) ;
	}
	
	
	function _replace_childs( &$set, &$element ) {
		$records = array() ;
		
		$childs = array() ;
		
		$childNodes =& $element->childNodes ;
		
		for ( $n = 0 ; $n < $childNodes->length ; $n++ ) {
			$child =& $childNodes->item( $n ) ;
			
			if ( $child->nodeType == XML_ELEMENT_NODE ) {
				$childs[] =& $child ;
			}
			
			unset( $child ) ;
		}
		
		for ( $n = 0 ; $n < count( $childs ) ; $n++ ) {
			$this->_replace_element( $set, $childs[ $n ], $records ) ;
		}
		
		foreach ( $records as $name => $record ) {
			list( $local, $localName ) = $this->_replace_get_local( $set, $name ) ;
			
			if ( ! isset( $local[ 'record' ][ $localName ] ) ) {
				for ( $n = 0 ; $n < count( $record ) ; $n++ ) {
					$this->_replace_remove( $record[ $n ] ) ;
				}
				
				continue ;
			}
			
			// 不必要な行を削除
			
			for ( $n = count( $set[ 'record' ][ $name ] ) ; $n < count( $record ) ; $n++ ) {
				$this->_replace_remove( $record[ $n ] ) ;
			}
			
			// 必要な行を用意
			
			if ( count( $set[ 'record' ][ $name ] ) > count( $record ) ) {
				
				$last =& $records[ $name ][ count( $records[ $name ] ) - 1 ] ;
				
				$source = array() ;
				
				if ( ! is_null( $last->previousSibling ) ) {
					if ( $last->previousSibling->nodeType == XML_TEXT_NODE ) {
						if ( trim( $last->previousSibling->nodeValue ) == '' ) {
							$source[] = $last->previousSibling->cloneNode() ;
						}
					}
				}
				
				$source[] = $last->cloneNode( true ) ;
				
				$anchor = $this->dom->createElement( $last->tagName ) ;
				
				if ( is_null( $last->nextSibling ) ) {
					$last->parentNode->appendChild( $anchor ) ;
				} else {
					$last->parentNode->insertBefore( $anchor, $last->nextSibling ) ;
				}
				
				unset( $anchor ) ;
				$anchor =& $last->nextSibling ;
				
				for ( $n = count( $record ) ; $n < count( $set[ 'record' ][ $name ] ) ; $n++ ) {
					for ( $s = 0 ; $s < count( $source ) ; $s++ ) {
						$node = $source[ $s ]->cloneNode( true ) ;
						
						$last->parentNode->insertBefore( $node, $anchor ) ;
						
						$node = $anchor->previousSibling ;
						
						if ( $node->nodeType == XML_ELEMENT_NODE ) {
							$record[] =& $node ;
						}
						
						unset( $node ) ;
					}
				}
				
				$last->parentNode->removeChild( $anchor ) ;
			}
			
			$dummy = array() ;
			
			for ( $n = 0 ; $n < count( $set[ 'record' ][ $name ] ) ; $n++ ) {
				$set[ 'record' ][ $name ][ $n ][ 'root' ] =& $this->set ;
				$set[ 'record' ][ $name ][ $n ][ 'parent' ] =& $set ;
				
				$child =& $record[ $n ] ;
				
				$this->_replace_element( $set[ 'record' ][ $name ][ $n ], $child, $dummy, false ) ;
				
				unset( $child ) ;
			}
		}
	}
	
	
	function _replace_get_commands( $attribute ) {
		$attribute = trim( $attribute ) ;
		
		$commands = array() ;
		
		while ( $attribute != '' ) {
			mb_ereg( '^([^;]+)\s*(;\s*|$)([^$]*)$', $attribute, $matches ) ;
			$attribute = trim( $matches[ 3 ] ) ;
			
			if ( mb_ereg( '^([^:]*)\s*:\s*([^$]*)$', $matches[ 1 ], $part ) ) {
				$command = trim( $part[ 1 ] ) ;
				$name = trim( $part[ 2 ] ) ;
			} else {
				$command = $matches[ 1 ] ;
				$name = '' ;
			}
			
			if ( mb_ereg( '^@(.+)$', $command, $match ) ) {
				if ( ! isset( $commands[ '@' ] ) ) $commands[ '@' ] =  array() ;
				$commands[ '@' ][] = array( 'attribute' => $match[ 1 ], 'name' => $name ) ;
			} else {
				switch ( $command ) {
					case 'remove' :
						$command = 'fake' ;
						break ;
					
					case 'dummy' :
						$command = 'fake' ;
						break ;
					
					case 'condition' :
						$command = 'if' ;
						break ;
					
					case 'condition_not' :
						$command = 'else' ;
						break ;
				}
				
				switch ( $command ) {
					case 'fake' :
						$commands[ 'fake' ] = true ;
						break ;
					
					case 'if' :
						if ( ! isset( $commands[ 'condition' ] ) ) $commands[ 'condition' ] =  array() ;
						$commands[ 'condition' ][] = array( 'condition' => true, 'name' => $name ) ;
						break ;
					
					case 'else' :
						if ( ! isset( $commands[ 'condition' ] ) ) $commands[ 'condition' ] =  array() ;
						$commands[ 'condition' ][] = array( 'condition' => false, 'name' => $name ) ;
						break ;
					
					case 'record' :
						$commands[ 'record' ] = $name ;
						break ;
					
					case 'outer' :
					case 'inner' :
					case 'text' :
					case 'textarea' :
						$commands[ $command ] = $name ;
						break ;
					
					default :
						if ( ! isset( $commands[ 'other' ] ) ) $commands[ 'other' ] =  array() ;
						$commands[ 'other' ][] = array( 'command' => $command, 'name' => $name ) ;
				}
			}
		}
		
		return $commands ;
	}
	
	
	function _replace_get_local( &$set, $name ) {
		if ( mb_ereg( '^([^^\.]+?)\.([^$]+)$', $name, $match ) ) {
			switch ( strtolower( trim( $match[ 1 ] ) ) ) {
				case 'root' :
					return array( $set[ 'root' ], trim( $match[ 2 ] ) ) ;
					break ;
				
				case 'parent' :
					return array( $set[ 'parent' ], trim( $match[ 2 ] ) ) ;
					break ;
			}
		}
		
		return array( &$set, $name ) ;
	}
	
	
	function _replace_remove( &$element ) {
		if ( ! is_null( $element->previousSibling ) ) {
			if ( $element->previousSibling->nodeType == XML_TEXT_NODE ) {
				if ( trim( $element->previousSibling->nodeValue ) == '' ) {
					$element->parentNode->removeChild( $element->previousSibling ) ;
				}
			}
		}
		
		$element->parentNode->removeChild( $element ) ;
	}
	
	
	function _replace_html( &$set, &$element, $command, $name ) {
		$this->log_write( "_replace_html: {$element->tagName}: {$command}: {$name}" ) ;
		if ( mb_ereg( '^url\(([^)]*)\)$', $name, $match ) ) {
			$parts = array() ;
			$urls = mb_split( '[ ,]\s*', $match[ 1 ] ) ;
			
			for ( $n = 0 ; $n < count( $urls ) ; $n++ ) {
				$url = trim( $urls[ $n ] ) ;
				
				if ( $url == '' ) continue ;
				
				$part = @file_get_contents( $url ) ;
				if ( $part === false ) return false ;
				
				$parts[] = rtrim( $this->_delete_bom( $part ) ) ;
			}
			
			$html = implode( "\n", $parts ) ;
		} else {
			list( $local, $localName ) = $this->_replace_get_local( $set, $name ) ;
			if ( ! isset( $local[ 'value' ][ $localName ] ) ) {
				$this->log_write( "_replace_html: {$element->tagName}: {$command}: {$localName}: ! isset" ) ;
				return false ;
			}
			$html = $local[ 'value' ][ $localName ] ;
		}
		
		if ( $command == 'outer' ) {
			$this->log_write( "_replace_html: {$element->tagName}: {$command}: {$name}: {$html}" ) ;
			$this->outerHTML( $element, $html ) ;
			return true ;
		}
		
		$this->innerHTML( $element, $html, true ) ;
		
		return true ;
	}
	
	
	//==================================================================
	// _tree
	
	function _tree( &$html, &$node ) {
		$xhtml = mb_ereg( '\sXHTML\s', $this->doctype ) ;
		$emptyTagEnd = ( $xhtml ) ? ' />' : '>' ;
		
		if ( $node->nodeType == XML_ELEMENT_NODE ) {
			$tag = array( $node->tagName )   ;
			
			$attributes =& $node->attributes ;
			
			for ( $n = 0 ; $n < $attributes->length ; $n++ ) {
				$attribute =& $attributes->item( $n ) ;
				
				$name = $attribute->name ;
				$value = $attribute->value ;
				
				if ( $value == '' ) {
					if ( in_array( $name, $this->blankAttribute ) ) continue ;
				}
				
				if ( $this->xhtml ) {
					$tag[] = htmlspecialchars( $name ) . '="' . $value . '"' ;
				} else {
					if ( in_array( $name, $this->blankAttribute ) ) {
						$tag[] = htmlspecialchars( $name ) ;
					} else {
						$tag[] = htmlspecialchars( $name ) . '="' . $value . '"' ;
					}
				}
			}
			
			if ( in_array( $node->tagName, $this->emptyTag ) ) {
				$html .= "<" . implode( ' ', $tag ) . ( ( $this->xhtml ) ? ' />' : '>' ) ;
			} else {
				$html .= "<" . implode( ' ', $tag ) . ">" ;
				$this->_tree_childs( $html, $node ) ;
				$html .= "</" . $node->tagName . ">" ;
			}
			
			return ;
		}
		
		if ( $node->nodeType == XML_COMMENT_NODE ) {
			$html .= "<!--" . $node->nodeValue . "-->" ;
			return ;
		}
		
		if ( $node->nodeType == XML_CDATA_SECTION_NODE ) {
			$html .= "<![CDATA[" . $node->nodeValue . "]]>" ;
			return ;
		}
		
		$html .= $node->nodeValue ;
	}
	
	
	function _tree_childs( &$html, &$node ) {
		for ( $n = 0 ; $n < $node->childNodes->length ; $n++ ) {
			$this->_tree( $html, $node->childNodes->item( $n ) ) ;
		}
	}
	
	
	function log_write( $text ) {
		if ( ! $this->log ) return ;
		
		$fh = fopen( $this->log_file, 'a' ) ;
		fwrite( $fh, date( '[Y-m-d H:i:s] ' ) . $text . "\n" ) ;
		fclose( $fh ) ;
	}
}
?>
