/*
 * Java Temlate Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.common.util;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.beanutils.PropertyUtils;

/**
 * PropertyUtilsのラッパークラスです。
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public final class PropertyUtilsWrapper {
    
    // --------------------------------------------------------- Constructor

    /**
     * コンストラクタ（外部からのインスタンス生成を許可しない）
     */
    private PropertyUtilsWrapper() {}

    // --------------------------------------------------------- Public Methods
    
    /**
     * プロパティをコピーします。
     * @param from コピー元のプロパティマップ
     * @param to コピー先オブジェクト
     */
    public static void copyProperties(Map from, Object to) {
        try {
            for (Iterator it = from.keySet().iterator(); it.hasNext();) {
                String key = (String) it.next();
                //コピー先へ設定可能か確認します
                if (!PropertyUtils.isWriteable(to, key)) continue;
                //コピー元のプロパティ値を取得します
                Object value = from.get(key);
                //コピー先にプロパティ値を設定します
                PropertyUtils.setProperty(to, key, value);
            }
        }
        catch (IllegalAccessException e) {
        	throw new RuntimeException("プロパティのコピーエラー", e);
        }
        catch (NoSuchMethodException e) {
        	throw new RuntimeException("プロパティのコピーエラー", e);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = ((InvocationTargetException) e).getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException) throwable;
            }
            else if (throwable instanceof Exception) {
                throw new RuntimeException("プロパティのコピーエラー", throwable);
            }
            else {
                throw new RuntimeException("プロパティのコピーエラー", e);
            }
        }
    }
}
