/*
 * Java Temlate Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.faces.model.SelectItem;

import org.jtp.web.util.FacesUtils;


/**
 * のバッキングビーンクラスです。
 * 
 * @jsf.bean
 *   name = "pager"
 *   scope = "session" 
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class PagerBean implements Serializable {
    // ------------------------------------------------------- Static Variables

    private static final String ROWS_KEY = "selection.pager.rows";

    private static final int[] ROWS_VALUES = { 10, 20, 50, 100 };

    // ----------------------------------------------------- Instance Variables

    private transient List _rowsItems;

    private int rows;

    private int fastStep;

    private int maxPages;

    // --------------------------------------------------------- Public Methods

    /**
     * 
     */
    public List getRowsItems() {
        if (_rowsItems == null) {
            _rowsItems = new ArrayList();
            for (int i = 0; i < ROWS_VALUES.length; i++) {
                Object value = String.valueOf(ROWS_VALUES[i]);
                String label = FacesUtils.formatMessage(ROWS_KEY, value);
                _rowsItems.add(new SelectItem(value, label));
            }
        }
        return _rowsItems;
    }

    // ----------------------------------------------------- Property Accessors

    /**
     * 
     * @return rows を戻します。
     * @jsf.managed-property
     *   value = "10"
     */
    public int getRows() {
        return rows;
    }

    /**
     * 
     * @param rows rows を設定。
     */
    public void setRows(int rows) {
        this.rows = rows;
    }

    /**
     * 
     * @return fastStep を戻します。
     * @jsf.managed-property
     *   value = "10"
     */
    public int getFastStep() {
        return fastStep;
    }

    /**
     * 
     * @param fastStep fastStep を設定。
     */
    public void setFastStep(int fastStep) {
        this.fastStep = fastStep;
    }

    /**
     * 
     * @return maxPages を戻します。
     * @jsf.managed-property
     *   value = "9"
     */
    public int getMaxPages() {
        return maxPages;
    }

    /**
     * 
     * @param maxPages maxPages を設定。
     */
    public void setMaxPages(int maxPages) {
        this.maxPages = maxPages;
    }
}
