/*
 * Java Temlate Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.sample;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jtp.SampleException;
import org.jtp.common.util.DateUtils;
import org.jtp.entity.TestTable;
import org.jtp.logic.ServiceLocator;
import org.jtp.logic.test.TestTableService;
import org.jtp.web.download.DownloadActionBean;
import org.jtp.web.download.DownloadBean;
import org.jtp.web.util.FacesUtils;

/**
 * サンプル画面イベントを処理するマネージドビーンクラスです。 
 * 
 * @jsf.bean
 *  name = "sampleAction"
 *  scope = "request"
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class SampleActionBean {
	
    /** このクラスで発生した実行状況をログに記録するためのオブジェクトです。 */
    private static final Log _log = LogFactory.getLog(SampleActionBean.class);

    /** テストテーブル情報サービス */
    private TestTableService _service;


    /**
     * コンストラクタ
     */
    public SampleActionBean() {
    	_service = (TestTableService) ServiceLocator.getService(TestTableService.BEAN_ID);
    }

	/**
	 * 登録アクションを処理します。
     * @param event イベント
	 */
	public void save(ActionEvent event) {
		_log.info("save");
		SampleBean bean = SampleBean.getBindingBean();
		TestTable condition = bean.getCondition();
        try {
        	_service.save(condition);
        	bean.setCondition(new TestTable());
    		search(event);
        }
        catch (SampleException e) {
            _log.error("登録アクション【異常終了】", e);
            FacesUtils.addExceptionMessages(e);
            throw new AbortProcessingException();
        }
   }
    
    /**
     * 検索アクションを処理します。
     * @param event イベント
     */
	public void search(ActionEvent event) {
		_log.info("search");
    	SampleBean bean = SampleBean.getBindingBean();
        try {
            bean.setTestTableList(_service.find(bean.getCondition()));
            ArrayList beanList = new ArrayList(bean.getTestTableList().size());
            for (Iterator it = bean.getTestTableList().iterator(); it.hasNext();) {
            	SearchListActionBean searchListActionBean = new SearchListActionBean();
            	searchListActionBean.setTestTable((TestTable) it.next());
                beanList.add(searchListActionBean);
            }
            bean.setSearchList(beanList);
        }
        catch (SampleException e) {
            _log.error("検索アクション【異常終了】", e);
            FacesUtils.addExceptionMessages(e);
            throw new AbortProcessingException();
        }
    }
	
    /**
     * ダウンロードアクションを処理します。
     * @param event イベント
     */
	public void download(ActionEvent event) {
    	SampleBean bean = SampleBean.getBindingBean();
    	DownloadBean downloadBean = new DownloadBean();
    	String date = DateUtils.dateToString(new Date(), "yyyyMMddHHmmss");
    	downloadBean.setFilename("search-list-" + date + ".txt");
    	downloadBean.setFactory(new SearchListCsvFactory(bean.getTestTableList()));
    	new DownloadActionBean(downloadBean).download(event);
	}

	/**
	 * 削除アクションを処理します。
     * @param event イベント
	 */
	public void remove(ActionEvent event) {
		_log.info("remove");
        try {
    		_service.delete(SampleBean.getBindingBean().getTestTable());
    		search(event);
        }
        catch (SampleException e) {
            _log.error("削除アクション【異常終了】", e);
            FacesUtils.addExceptionMessages(e);
            throw new AbortProcessingException();
        }
	}

	/**
	 * 更新アクションを処理します。
     * @param event イベント
	 */
	public void update(ActionEvent event) {
		_log.info("update");
        try {
    		_service.update(SampleBean.getBindingBean().getTestTable());
    		search(event);
        }
        catch (SampleException e) {
            _log.error("更新アクション【異常終了】", e);
            FacesUtils.addExceptionMessages(e);
            throw new AbortProcessingException();
        }
	}
}
