/*
 * Java Temlate Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web;

import java.io.Serializable;

import javax.faces.application.Application;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/**
 * 
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
@SuppressWarnings("serial")
public class WebContext implements Serializable {

    /**
     * FacesConextを返します。
     * @return FacesConext
     */
    public static FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    /**
     * ExternalContextを返します。
     * @return ExternalContext
     */
    public static ExternalContext getExternalCotext() {
        return (ExternalContext) getFacesContext().getExternalContext();
    }

    /**
     * HttpServletRequestを返します。
     * @return HttpServletRequest
     */
    public static HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest) getExternalCotext().getRequest();
    }

    /**
     * HttpSessionを返します。
     * @return HttpSession
     */
    public static HttpSession getHttpSession() {
        return (HttpSession) getExternalCotext().getSession(false);
    }

    /**
     * バインディングされているオブジェクト返します。
     * @param name
     * @return
     */
    public static Object getBindingBean(String attribute) {
        StringBuffer buffer = new StringBuffer("#{").append(attribute).append("}");
        return getBindingValue(buffer.toString());
    }
    
    /**
     * 
     * @param expression
     * @return
     */
    public static Object getBindingValue(String expression) {
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        ValueBinding valueBinding = application.createValueBinding(expression);
        return valueBinding.getValue(context);
    }
}
