/*
 * Java Temlate Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.sample;

import javax.faces.FacesException;
import javax.faces.event.ActionEvent;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jtp.entity.TestTable;

/**
 * 検索結果情報を保持するクラスです。 
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class SearchListActionBean {

    /** このクラスで発生した実行状況をログに記録するためのオブジェクトです。 */
    private static final Log _log = LogFactory.getLog(SearchListActionBean.class);
    
    /** テストテーブル情報 */
    private TestTable testTable;

    /**
     * コンストラクタ
     */
    public SearchListActionBean() {
    }

    /**
     * テストテーブル情報を取得する
     * @return テストテーブル情報
     */
    public TestTable getTestTable() {
        return testTable;
    }

    /**
     * テストテーブル情報を設定する
     * @param testTable テストテーブル情報
     */
    public void setTestTable(TestTable testTable) {
        this.testTable = testTable;
    }

    /**
     * 一覧画面で編集ボタン押下時
     * @param event イベント
     * @throws FacesException JSF例外
     */
    public void update(ActionEvent event) {
    	_log.info("update confirm");
    	SampleBean.getBindingBean().setTestTable(getTestTable());
    }

    /**
     * 一覧画面で削除ボタン押下時
     * @param event イベント
     * @throws FacesException JSF例外
     */
    public void remove(ActionEvent event) {
    	_log.info("remove confirm");
    	SampleBean.getBindingBean().setTestTable(getTestTable());
    }
}
