/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web;

import java.io.UnsupportedEncodingException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.struts.DelegatingTilesRequestProcessor;

/**
 * コンテナから各サーブレットリクエストを受け取り、 ActionServlet が実行する処理ロジックを含みます。
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class SampleRequestProcessor extends DelegatingTilesRequestProcessor {

	/** Log用オブジェクト */
	private Log _log = LogFactory.getLog(this.getClass().getName());

	/** 文字エンコーディング */
	private static final String ENCODING = "Windows-31J";

	/**
	 * サブクラスにより処理内容をオーバライドすることで、 多目的な前処理を行うことができます。 
	 * @param request  処理しているHTTPリクエスト
	 * @param response 処理しているHTTPレスポンス
	 * @return 標準処理が継続される場合 true を返します。 また、レスポンスが既に完成した場合 false を返します。
	 */
	protected boolean processPreprocess(HttpServletRequest request, HttpServletResponse response) {
		try {
			//リクエスト変数のエンコーディングを設定する
			request.setCharacterEncoding(ENCODING);
		} catch (UnsupportedEncodingException uee) {
			_log.warn("サポートされていない文字エンコーディングです。");
		}
		return true;
	}
}
